/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status.migration;

import com.atlassian.bitbucket.internal.build.status.migration.MigrationState;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.HomeLayout;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;

public final class BuildStatusMigrationStateHelper {
    public static final String KEY_TASK = "core-builds-ao-mig";

    private BuildStatusMigrationStateHelper() {
    }

    public static Path getMarkerPath(HomeLayout homeLayout) {
        Path markerPath = homeLayout.getUpgradesDir().resolve(KEY_TASK);
        if (!Files.exists(markerPath, new LinkOption[0])) {
            MoreFiles.mkdir((Path)markerPath.getParent());
            BuildStatusMigrationStateHelper.writeMigrationStateToFile(markerPath, MigrationState.STEP1_ASYNC_LIQUIBASE_MIGRATION);
        }
        return markerPath;
    }

    public static ResettableLazyReference<MigrationState> getMigrationStatus(final Path markerPath) {
        return new ResettableLazyReference<MigrationState>(){

            protected MigrationState create() throws Exception {
                String state = IOUtils.toString((URI)markerPath.toUri(), (Charset)StandardCharsets.UTF_8);
                return MigrationState.valueOf(state);
            }
        };
    }

    public static void writeMigrationStateToFile(Path markerPath, MigrationState migrationState) {
        try (FileOutputStream out = new FileOutputStream(markerPath.toFile());){
            IOUtils.write((String)migrationState.toString(), (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

