/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status.migration;

import com.atlassian.bitbucket.build.BuildOrder;
import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.BuildStatusParent;
import com.atlassian.bitbucket.dmz.build.status.dao.DmzLegacyBuildDao;
import com.atlassian.bitbucket.dmz.build.status.legacy.BuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.internal.build.status.dao.BuildCountForRef;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusBulkCommitSummaryCriteria;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusBulkRefSummaryCriteria;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusDao;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusSearchCriterion;
import com.atlassian.bitbucket.internal.build.status.migration.BuildStatusMigrationStateHelper;
import com.atlassian.bitbucket.internal.build.status.migration.BuildStatusMigrationStatusChanged;
import com.atlassian.bitbucket.internal.build.status.migration.MigrationState;
import com.atlassian.bitbucket.internal.build.status.model.InternalBuildStatus;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.plugin.OsgiServiceProxyFactory;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Transactional(readOnly=true)
public class MigrationBuildStatusDao
implements BuildStatusDao {
    private final BuildStatusDao buildStatusDao;
    private final DmzLegacyBuildDao legacyBuildDao;
    private final ResettableLazyReference<MigrationState> migrationStatus;
    private final TransactionTemplate withNewTransaction;

    public MigrationBuildStatusDao(BuildStatusDao buildStatusDao, HomeLayout homeLayout, DmzLegacyBuildDao legacyBuildDao, TopicService topicService, TransactionTemplate transactionTemplate) {
        this.buildStatusDao = buildStatusDao;
        this.legacyBuildDao = legacyBuildDao;
        this.migrationStatus = BuildStatusMigrationStateHelper.getMigrationStatus(BuildStatusMigrationStateHelper.getMarkerPath(homeLayout));
        this.withNewTransaction = transactionTemplate;
        topicService.getTopic("upgrade:buildstatus.migration.state.changed", TopicSettings.builder(BuildStatusMigrationStatusChanged.class).build()).subscribe(message -> this.migrationStatus.reset());
    }

    public MigrationBuildStatusDao(BuildStatusDao buildStatusDao, HomeLayout homeLayout, TopicService topicService, OsgiServiceProxyFactory serviceProxyFactory, PlatformTransactionManager transactionManager) {
        this(buildStatusDao, homeLayout, (DmzLegacyBuildDao)serviceProxyFactory.createProxy(DmzLegacyBuildDao.class), topicService, new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW));
    }

    @Override
    @Nonnull
    public Map<BuildState, Integer> countByState(@Nonnull String commitId) {
        if (this.isMigrationRunning()) {
            return this.legacyBuildDao.countByState(commitId);
        }
        return this.buildStatusDao.countByState(commitId);
    }

    @Override
    @Nonnull
    public Map<String, Map<BuildState, Integer>> countByState(@Nonnull Collection<String> commitIds) {
        if (this.isMigrationRunning()) {
            return this.legacyBuildDao.countByState(commitIds);
        }
        return this.buildStatusDao.countByState(commitIds);
    }

    @Override
    @Nonnull
    public Map<String, Map<BuildState, Integer>> countByState(@Nonnull BuildStatusBulkCommitSummaryCriteria summaryCriterion) {
        if (this.isMigrationRunning()) {
            return this.legacyBuildDao.countByState(summaryCriterion.getCommitIds());
        }
        return this.buildStatusDao.countByState(summaryCriterion);
    }

    @Override
    @Nonnull
    public List<BuildCountForRef> countByState(@Nonnull BuildStatusBulkRefSummaryCriteria summaryCriterion) {
        if (this.isMigrationRunning()) {
            Collection<String> commitIds = summaryCriterion.getCommitIds();
            Map legacyResults = this.legacyBuildDao.countByState(commitIds);
            ArrayList<BuildCountForRef> buildCounts = new ArrayList<BuildCountForRef>();
            legacyResults.forEach((commitId, countsByState) -> {
                BuildCountForRef cancelledCount = new BuildCountForRef((String)commitId, BuildState.CANCELLED, countsByState.getOrDefault(BuildState.CANCELLED, 0));
                BuildCountForRef successCount = new BuildCountForRef((String)commitId, BuildState.SUCCESSFUL, countsByState.getOrDefault(BuildState.SUCCESSFUL, 0));
                BuildCountForRef failedCount = new BuildCountForRef((String)commitId, BuildState.FAILED, countsByState.getOrDefault(BuildState.FAILED, 0));
                BuildCountForRef inProgressCount = new BuildCountForRef((String)commitId, BuildState.INPROGRESS, countsByState.getOrDefault(BuildState.INPROGRESS, 0));
                BuildCountForRef unknownCount = new BuildCountForRef((String)commitId, BuildState.UNKNOWN, countsByState.getOrDefault(BuildState.UNKNOWN, 0));
                buildCounts.add(cancelledCount);
                buildCounts.add(successCount);
                buildCounts.add(failedCount);
                buildCounts.add(inProgressCount);
                buildCounts.add(unknownCount);
            });
            return buildCounts;
        }
        return this.buildStatusDao.countByState(summaryCriterion);
    }

    @Nonnull
    public InternalBuildStatus create(InternalBuildStatus entity) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    public void delete(InternalBuildStatus entity) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    @Override
    public int delete(int repositoryId, @Nonnull String commitId, @Nonnull String key) {
        return (Integer)this.withNewTransaction.execute(transactionStatus -> {
            MigrationState migrationStatus = this.getMigrationStatus();
            switch (migrationStatus) {
                case DONE: {
                    return this.buildStatusDao.delete(repositoryId, commitId, key);
                }
                case STEP1_ASYNC_LIQUIBASE_MIGRATION: {
                    return this.legacyBuildDao.delete(commitId, key);
                }
                case STEP2_JAVA_MIGRATION: {
                    this.legacyBuildDao.delete(commitId, key);
                    return this.buildStatusDao.delete(repositoryId, commitId, key);
                }
            }
            throw new IllegalStateException("Invalid migration status " + String.valueOf((Object)migrationStatus));
        });
    }

    public void deleteById(Integer id) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    @Override
    public int deleteByRepositoryId(int repositoryId) {
        if (this.isMigrationRunning()) {
            return 0;
        }
        return this.buildStatusDao.deleteByRepositoryId(repositoryId);
    }

    @Nonnull
    public Page<InternalBuildStatus> findAll(PageRequest p) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    @Nonnull
    public Page<InternalBuildStatus> findAll(PageRequest pageRequest, Predicate<? super InternalBuildStatus> predicate) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    @Override
    @Nonnull
    public Page<InternalBuildStatus> findAll(@Nonnull String commitId, @Nonnull PageRequest pageRequest, @Nonnull BuildOrder orderBy) {
        if (this.isMigrationRunning()) {
            return this.legacyBuildDao.findAll(commitId, pageRequest, orderBy).transform(status -> new InternalBuildStatus.Builder((LegacyBuildStatus)status, commitId).build());
        }
        return this.buildStatusDao.findAll(commitId, pageRequest, orderBy);
    }

    @Override
    @Nonnull
    public Page<InternalBuildStatus> findAll(@Nonnull List<BuildStatusSearchCriterion> searchCriteria, @Nonnull List<String> commitIds, @Nonnull PageRequest pageRequest, @Nonnull BuildOrder orderBy) {
        if (this.isMigrationRunning()) {
            return this.findAllWhileMigrationIsRunning(searchCriteria, commitIds, pageRequest, orderBy);
        }
        return this.buildStatusDao.findAll(searchCriteria, commitIds, pageRequest, orderBy);
    }

    @Override
    @Nonnull
    public Page<InternalBuildStatus> findAll(@Nonnull List<BuildStatusSearchCriterion> searchCriteria, @Nonnull List<String> commitIds, @Nonnull PageRequest pageRequest, @Nonnull BuildOrder orderBy, @Nonnull Predicate<InternalBuildStatus> predicate) {
        if (this.isMigrationRunning()) {
            return this.findAllWhileMigrationIsRunning(searchCriteria, commitIds, pageRequest, orderBy);
        }
        return this.buildStatusDao.findAll(searchCriteria, commitIds, pageRequest, orderBy, predicate);
    }

    @Override
    @Nonnull
    public Page<BuildStatusParent> findMatchingParents(int repositoryId, @Nonnull String filter, @Nonnull Date earliestCreatedDate, @Nonnull PageRequest pageRequest) {
        if (this.isMigrationRunning()) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.buildStatusDao.findMatchingParents(repositoryId, filter, earliestCreatedDate, pageRequest);
    }

    @Override
    @Nonnull
    public Optional<InternalBuildStatus> get(int repositoryId, @Nonnull String commitId, @Nonnull String key) {
        if (this.isMigrationRunning()) {
            return this.legacyBuildDao.get(commitId, key).map(status -> new InternalBuildStatus.Builder((LegacyBuildStatus)status, commitId).build());
        }
        return this.buildStatusDao.get(repositoryId, commitId, key);
    }

    public InternalBuildStatus getById(Integer id) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    @Nonnull
    public List<InternalBuildStatus> getByIds(@Nonnull Collection<Integer> ids) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    public InternalBuildStatus loadById(Integer id) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    public void refresh(InternalBuildStatus entity) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    @Override
    @Nonnull
    public InternalBuildStatus set(@Nonnull RepositoryBuildStatusSetRequest request, @Nullable String buildServerId) {
        return (InternalBuildStatus)this.withNewTransaction.execute(transactionStatus -> {
            MigrationState migrationStatus = this.getMigrationStatus();
            switch (migrationStatus) {
                case DONE: {
                    return this.buildStatusDao.set(request, buildServerId);
                }
                case STEP1_ASYNC_LIQUIBASE_MIGRATION: {
                    return new InternalBuildStatus.Builder(this.legacyBuildDao.set(request), request.getCommitId()).repository(InternalConverter.convertToInternalRepository((Repository)request.getRepository())).build();
                }
                case STEP2_JAVA_MIGRATION: {
                    this.legacyBuildDao.set(request);
                    return this.buildStatusDao.set(request, buildServerId);
                }
            }
            throw new IllegalStateException("Invalid migration status " + String.valueOf((Object)migrationStatus));
        });
    }

    @Override
    @Nonnull
    public InternalBuildStatus set(@Nonnull BuildStatusSetRequest request, Date dateAdded) {
        return (InternalBuildStatus)this.withNewTransaction.execute(transactionStatus -> {
            MigrationState migrationStatus = this.getMigrationStatus();
            switch (migrationStatus) {
                case DONE: {
                    return this.buildStatusDao.set(request, dateAdded);
                }
                case STEP1_ASYNC_LIQUIBASE_MIGRATION: {
                    return new InternalBuildStatus.Builder(this.legacyBuildDao.set(request, dateAdded), request.getCommitId()).build();
                }
                case STEP2_JAVA_MIGRATION: {
                    this.legacyBuildDao.set(request, dateAdded);
                    return this.buildStatusDao.set(request, dateAdded);
                }
            }
            throw new IllegalStateException("Invalid migration status " + String.valueOf((Object)migrationStatus));
        });
    }

    public InternalBuildStatus update(InternalBuildStatus entity) {
        throw new UnsupportedOperationException("The migrationBuildStatusDao is not a real dao. It only marshals requests to the correct dao based on the current status of migration");
    }

    public InternalBuildStatus updateAndFlush(InternalBuildStatus entity) {
        return this.update(entity);
    }

    private Page<InternalBuildStatus> findAllWhileMigrationIsRunning(List<BuildStatusSearchCriterion> searchCriteria, @Nonnull List<String> commitIds, PageRequest pageRequest, BuildOrder orderBy) {
        return searchCriteria.stream().flatMap(criterion -> {
            if (criterion.getLatestCommitOnRef() == null) {
                return commitIds.stream();
            }
            return Stream.of(criterion.getLatestCommitOnRef());
        }).filter(Objects::nonNull).findFirst().map(commitId -> this.legacyBuildDao.findAll(commitId, pageRequest, orderBy).transform(status -> new InternalBuildStatus.Builder((LegacyBuildStatus)status, (String)commitId).build())).orElseGet(() -> PageUtils.createEmptyPage((PageRequest)pageRequest));
    }

    private MigrationState getMigrationStatus() {
        return (MigrationState)((Object)this.migrationStatus.get());
    }

    private boolean isMigrationRunning() {
        return this.getMigrationStatus() != MigrationState.DONE;
    }
}

