/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status.model;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.build.status.TestResults;
import com.atlassian.bitbucket.dmz.build.status.legacy.BuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;

@Entity
@Table(name="bb_build_status", indexes={@Index(name="idx_bb_build_status_commit_id", columnList="commit_id"), @Index(name="idx_bb_build_status_repo_id", columnList="repository_id"), @Index(name="idx_bb_build_status_repo_ref", columnList="repository_id, ref"), @Index(name="idx_bb_build_status_rcp", columnList="repository_id, created_date, parent")})
@TableGenerator(allocationSize=10, pkColumnValue="bb_build_status", name="buildStatusIdGenerator", table="id_sequence")
public class InternalBuildStatus
implements Initializable {
    public static final String ID_GEN = "buildStatusIdGenerator";
    public static final String TABLE = "bb_build_status";
    public static final int NON_NULL_REPOSITORY_ID_DEFAULT = -1;
    @Column(name="build_number")
    private String buildNumber;
    @Column(name="build_server_id")
    private String buildServerId;
    @Column(name="commit_id", nullable=false)
    private String commitId;
    @Column(name="created_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @Column(name="description")
    private String description;
    @Column(name="duration")
    private Long duration;
    @Column(name="failed_tests")
    private Integer failedTests;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="buildStatusIdGenerator", strategy=GenerationType.TABLE)
    private int id;
    @Column(name="build_key", nullable=false)
    private String key;
    @Column(name="name")
    private String name;
    @Column(name="parent")
    private String parent;
    @Column(name="ref")
    private String ref;
    @JoinColumn(name="repository_id", nullable=true, foreignKey=@ForeignKey(name="fk_bb_build_status_repository"))
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    private InternalRepository repository;
    @Column(name="non_null_repository_id", nullable=false)
    private int nonNullRepositoryId;
    @Column(name="skipped_tests")
    private Integer skippedTests;
    @Column(name="state", nullable=false)
    private String state;
    @Column(name="successful_tests")
    private Integer successfulTests;
    @Column(name="updated_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updatedDate;
    @Column(name="url", nullable=false)
    private String url;

    protected InternalBuildStatus() {
        this.id = 0;
    }

    private InternalBuildStatus(Builder builder) {
        Date now = new Date();
        this.createdDate = (Date)MoreObjects.firstNonNull((Object)builder.createdDate, (Object)now);
        this.id = (Integer)MoreObjects.firstNonNull((Object)builder.id, (Object)0);
        this.nonNullRepositoryId = builder.repository == null ? -1 : builder.repository.getId();
        this.updatedDate = (Date)MoreObjects.firstNonNull((Object)builder.updatedDate, (Object)now);
        this.buildNumber = builder.buildNumber;
        this.buildServerId = builder.buildServerId;
        this.commitId = builder.commitId;
        this.description = builder.description;
        this.duration = builder.duration;
        this.failedTests = builder.failedTests;
        this.key = builder.key;
        this.name = builder.name;
        this.parent = builder.parent;
        this.ref = builder.ref;
        this.repository = builder.repository;
        this.skippedTests = builder.skippedTests;
        this.state = builder.state;
        this.successfulTests = builder.successfulTests;
        this.url = builder.url;
    }

    @Nullable
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Nullable
    public String getBuildServerId() {
        return this.buildServerId;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Long getDuration() {
        return this.duration;
    }

    public Integer getFailedTests() {
        return this.failedTests;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getParent() {
        return this.parent;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Nullable
    public InternalRepository getRepository() {
        return this.repository;
    }

    public Integer getSkippedTests() {
        return this.skippedTests;
    }

    @Nonnull
    public BuildState getState() {
        return BuildState.fromString((String)this.state);
    }

    public Integer getSuccessfulTests() {
        return this.successfulTests;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public void initialize() {
        InternalRepository repository = this.getRepository();
        if (repository != null) {
            HibernateUtils.initialize((Object)repository);
        }
    }

    public static class Builder {
        private final String commitId;
        private final String description;
        private final String key;
        private final String name;
        private final String state;
        private final String url;
        private String buildNumber;
        private String buildServerId;
        private Date createdDate;
        private Long duration;
        private Integer failedTests;
        private Integer id;
        private String parent;
        private String ref;
        private InternalRepository repository;
        private Integer skippedTests;
        private Integer successfulTests;
        private Date updatedDate;

        public Builder(@Nonnull RepositoryBuildStatusSetRequest request) {
            Objects.requireNonNull(request, "request");
            this.buildNumber = request.getBuildNumber();
            this.commitId = request.getCommitId();
            this.description = request.getDescription();
            this.duration = request.getDuration();
            this.key = request.getKey();
            this.name = request.getName();
            this.parent = request.getParent();
            this.ref = request.getRef();
            this.repository = InternalConverter.convertToInternalRepository((Repository)request.getRepository());
            this.state = request.getState().toString();
            this.updatedDate = request.getLastUpdated();
            this.url = request.getUrl();
            TestResults testResults = request.getTestResults();
            if (testResults != null) {
                testResults.getFailed().ifPresent(failedTests -> {
                    this.failedTests = failedTests;
                });
                testResults.getSkipped().ifPresent(skippedTests -> {
                    this.skippedTests = skippedTests;
                });
                testResults.getSuccessful().ifPresent(successfulTests -> {
                    this.successfulTests = successfulTests;
                });
            }
        }

        public Builder(@Nonnull BuildStatusSetRequest request) {
            Objects.requireNonNull(request, "request");
            this.commitId = request.getCommitId();
            this.description = request.getDescription();
            this.key = request.getKey();
            this.name = request.getName();
            this.state = request.getState().toString();
            this.url = request.getUrl();
        }

        public Builder(@Nonnull LegacyBuildStatus buildStatus, @Nonnull String commitId) {
            Objects.requireNonNull(buildStatus, "buildStatus");
            this.commitId = Objects.requireNonNull(commitId, "commitId");
            this.createdDate = buildStatus.getCreatedDate();
            this.description = buildStatus.getDescription();
            this.key = buildStatus.getKey();
            this.name = buildStatus.getName();
            this.state = buildStatus.getState().toString();
            this.updatedDate = buildStatus.getUpdatedDate();
            this.url = buildStatus.getUrl();
        }

        @Nonnull
        public InternalBuildStatus build() {
            return new InternalBuildStatus(this);
        }

        @Nonnull
        public Builder previousBuildStatus(@Nonnull InternalBuildStatus value) {
            Objects.requireNonNull(value, "previousBuildStatus");
            this.id = value.getId();
            this.createdDate = value.getCreatedDate();
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Date value) {
            this.updatedDate = Objects.requireNonNull(value, "updatedDate");
            return this;
        }

        public Builder buildServerId(@Nullable String value) {
            this.buildServerId = value;
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull InternalRepository value) {
            this.repository = value;
            return this;
        }
    }
}

