/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.build.operations.DmzBuildServerOperationsService;
import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerAuthorizationService;
import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerService;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatusService;
import com.atlassian.bitbucket.dmz.commit.DmzCommitEnricher;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.DefaultBuildServerAuthorizationService;
import com.atlassian.bitbucket.internal.build.DefaultBuildServerOperationsService;
import com.atlassian.bitbucket.internal.build.DefaultBuildServerService;
import com.atlassian.bitbucket.internal.build.status.DefaultBuildStatusService;
import com.atlassian.bitbucket.internal.build.status.DefaultLegacyBuildStatusService;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusDao;
import com.atlassian.bitbucket.internal.build.status.dao.HibernateBuildStatusDao;
import com.atlassian.bitbucket.internal.build.status.migration.BuildStatusMigrationRunner;
import com.atlassian.bitbucket.internal.build.status.migration.MigrationBuildStatusDao;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.cache.CacheFactory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.plugin.OsgiServiceProxyFactory;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.utils.ExpressionUtils;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class BuildWiring {
    @Bean
    ThreadPoolExecutor buildStatusActionExecutor(@Value(value="${build.actions.threads.max}") String maxPoolSize) {
        return new ThreadPoolExecutor(0, ExpressionUtils.parseExpressionAsInt((String)maxPoolSize).orElse(4), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"build-actions"));
    }

    @AvailableToPlugins(value=DmzBuildServerOperationsService.class)
    @Bean
    DmzBuildServerOperationsService buildServerOperationsService(AuthenticationContext authenticationContext, EventPublisher eventPublisher, InternalApplicationPropertiesService propertiesService, CacheFactory cacheFactory, DmzBuildServerService buildServerService, DmzBuildStatusService buildStatusService, @Qualifier(value="buildStatusActionExecutor") ExecutorService executorService, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, TransferableStateManager stateManager) {
        return new DefaultBuildServerOperationsService(authenticationContext, propertiesService, eventPublisher, cacheFactory, buildServerService, buildStatusService, executorService, i18nService, permissionService, permissionValidationService, stateManager);
    }

    @AvailableToPlugins(value=DmzBuildServerAuthorizationService.class)
    @Bean
    DmzBuildServerAuthorizationService buildServerAuthorizationService(ApplicationPropertiesService applicationPropertiesService, DmzBuildServerService buildServerService, I18nService i18nService, PermissionValidationService permissionValidationService, EventPublisher eventPublisher) {
        return new DefaultBuildServerAuthorizationService(applicationPropertiesService, buildServerService, i18nService, permissionValidationService, eventPublisher);
    }

    @AvailableToPlugins(value=DmzBuildServerService.class)
    @Bean
    DmzBuildServerService buildServerService(I18nService i18nService, PluginAccessor pluginAccessor, RequestManager requestManager) {
        return new DefaultBuildServerService(i18nService, pluginAccessor, requestManager);
    }

    @Bean(value={"buildStatusDao"})
    BuildStatusDao buildStatusDao(SessionFactory sessionFactory, @Value(value="${hibernate.jdbc.batch_size}") int batchSize) {
        return new HibernateBuildStatusDao(sessionFactory, batchSize);
    }

    @Bean
    @DefaultApplicationMode
    BuildStatusMigrationRunner buildStatusMigrationRunner(ApplicationPropertyDao applicationPropertyDao, @Qualifier(value="buildStatusDao") BuildStatusDao buildStatusDao, OsgiServiceProxyFactory serviceProxyFactory, ExecutorService executorService, HomeLayout homeLayout, LockService lockService, PlatformTransactionManager platformTransactionManager, TopicService topicService) {
        return new BuildStatusMigrationRunner(applicationPropertyDao, buildStatusDao, executorService, homeLayout, lockService, topicService, platformTransactionManager, serviceProxyFactory);
    }

    @AvailableToPlugins(interfaces={RepositoryBuildStatusService.class, DmzBuildStatusService.class})
    @Bean
    DmzBuildStatusService repositoryBuildStatusService(@Qualifier(value="migrationBuildStatusDao") BuildStatusDao buildStatusDao, DmzBuildServerService buildServerService, DmzCommitEnricher commitEnricher, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, PlatformTransactionManager platformTransactionManager, InternalPullRequestService pullRequestService, RefService refService, @Value(value="${build.status.reject-untrusted:false}") boolean rejectUntrustedBuildStatus, ScmService scmService) {
        return new DefaultBuildStatusService(buildStatusDao, buildServerService, commitEnricher, eventPublisher, i18nService, permissionValidationService, platformTransactionManager, pullRequestService, refService, rejectUntrustedBuildStatus, scmService);
    }

    @AvailableToPlugins(value=LegacyBuildStatusService.class)
    @Bean
    LegacyBuildStatusService buildStatusService(@Qualifier(value="migrationBuildStatusDao") BuildStatusDao buildStatusDao, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, PlatformTransactionManager platformTransactionManager, ApplicationPropertiesService propertiesService, @Value(value="${build.status.reject-untrusted:false}") boolean rejectUntrustedBuildStatus) {
        return new DefaultLegacyBuildStatusService(buildStatusDao, eventPublisher, i18nService, permissionValidationService, platformTransactionManager, propertiesService, rejectUntrustedBuildStatus);
    }

    @Bean(value={"migrationBuildStatusDao"})
    BuildStatusDao migrationBuildStatusDao(@Qualifier(value="buildStatusDao") BuildStatusDao buildStatusDao, HomeLayout homeLayout, OsgiServiceProxyFactory serviceProxyFactory, TopicService topicService, PlatformTransactionManager platformTransactionManager) {
        return new MigrationBuildStatusDao(buildStatusDao, homeLayout, topicService, serviceProxyFactory, platformTransactionManager);
    }
}

