/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.menu.client.capabilities;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilities;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilitiesBuilder;
import com.atlassian.plugins.navlink.util.date.UniversalDateFormatter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.impl.client.BasicResponseHandler;

public class CapabilitiesResponseHandler
implements ResponseHandler<RemoteApplicationWithCapabilities> {
    private static final String CAPABILITIES = "capabilities";
    protected final ReadOnlyApplicationLink applicationLink;
    protected final ResponseHandler<String> basicHandler = new BasicResponseHandler();

    public CapabilitiesResponseHandler(ReadOnlyApplicationLink applicationLink) {
        this.applicationLink = Objects.requireNonNull(applicationLink);
    }

    public RemoteApplicationWithCapabilities handleResponse(HttpResponse response) throws IOException {
        String responseBody = (String)this.basicHandler.handleResponse(response);
        return StringUtils.isNotBlank((CharSequence)responseBody) ? this.parseBody(responseBody) : null;
    }

    protected RemoteApplicationWithCapabilities parseBody(String responseBody) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNodes = (JsonNode)mapper.readValue(responseBody, JsonNode.class);
        return new RemoteApplicationWithCapabilitiesBuilder().setApplicationLinkId(this.applicationLink.getId().toString()).setSelfUrl(this.parseSelfUrl(jsonNodes)).setType(jsonNodes.path("application").asText(null)).setBuildDateTime(this.getBuildDate(jsonNodes)).addAllCapabilities(this.collectCapabilities(jsonNodes)).build();
    }

    @Nullable
    private String parseSelfUrl(JsonNode jsonNodes) {
        return jsonNodes.path("links").path("self").asText(null);
    }

    @Nullable
    private ZonedDateTime getBuildDate(JsonNode jsonNodes) {
        String buildDateString = jsonNodes.path("buildDate").asText(null);
        if (!Strings.isNullOrEmpty((String)buildDateString)) {
            return UniversalDateFormatter.parse(buildDateString);
        }
        return null;
    }

    private Map<String, String> collectCapabilities(JsonNode jsonNodes) {
        ImmutableMap.Builder capabilitiesBuilder = ImmutableMap.builder();
        Iterator capabilities = jsonNodes.path(CAPABILITIES).fieldNames();
        while (capabilities.hasNext()) {
            String capabilityUrl;
            String capabilityName = (String)capabilities.next();
            if (Strings.isNullOrEmpty((String)capabilityName) || Strings.isNullOrEmpty((String)(capabilityUrl = jsonNodes.path(CAPABILITIES).path(capabilityName).asText(null)))) continue;
            capabilitiesBuilder.put((Object)capabilityName, (Object)capabilityUrl);
        }
        return capabilitiesBuilder.build();
    }
}

