/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.capabilities.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugins.navlink.producer.capabilities.Capability;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;

public class CapabilityModuleDescriptor
extends AbstractModuleDescriptor<Capability> {
    private Element element;
    private boolean enabled;

    public CapabilityModuleDescriptor(@Nonnull ModuleFactory moduleFactory) {
        super(Objects.requireNonNull(moduleFactory));
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) {
        super.init(plugin, element);
        this.element = element;
        this.enabled = false;
    }

    protected void validate(Element element) {
        super.validate(element);
        ArrayList<String> errors = new ArrayList<String>();
        if (element.element("url") == null) {
            errors.add("url tag is mandatory");
        } else if (element.elementTextTrim("url").isEmpty()) {
            errors.add("url tag requires a url as content");
        }
        if (element.element("name") == null) {
            errors.add("name tag is mandatory");
        } else if (element.elementTextTrim("name").isEmpty()) {
            errors.add("name tag requires a name as content");
        }
        if (element.attributeNames().contains("type") && element.attributeValue("type", "").trim().isEmpty()) {
            errors.add("type attribute of the capability tag is empty");
        }
        if (!errors.isEmpty()) {
            String moduleKey = element.attributeValue("key");
            throw new ValidationException(String.format("CapabilityModuleDescriptor validation errors <capability key=\"%s\"", moduleKey), errors);
        }
    }

    public void enabled() {
        super.enabled();
        this.enabled = true;
    }

    public void disabled() {
        super.disabled();
        this.enabled = false;
    }

    public Capability getModule() {
        return this.enabled ? this.parseCapability() : null;
    }

    @Nonnull
    private Capability parseCapability() {
        String type = this.parseType();
        String name = this.parseName();
        String url = this.parseUrl();
        return new Capability(type, name, url);
    }

    @Nonnull
    private String parseType() {
        return this.element.attributeValue("type", "").trim();
    }

    @Nonnull
    private String parseName() {
        return this.parseElementContent(this.element.element("name"));
    }

    @Nonnull
    private String parseUrl() {
        return this.parseElementContent(this.element.element("url"));
    }

    @Nonnull
    private String parseElementContent(@Nullable Element element) {
        String content = element != null ? element.getTextTrim().trim() : null;
        return Strings.nullToEmpty((String)content);
    }
}

