/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.navigation.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.AbstractWebFragmentModuleDescriptor;
import com.atlassian.plugins.navlink.producer.capabilities.services.ApplicationTypeService;
import com.atlassian.plugins.navlink.producer.navigation.links.LinkSource;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLink;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLinkBuilder;
import com.atlassian.plugins.navlink.spi.weights.ApplicationWeights;
import com.google.common.base.Strings;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;

public class NavigationLinkModuleDescriptor
extends AbstractWebFragmentModuleDescriptor<RawNavigationLink> {
    private final ApplicationWeights applicationWeights;
    private final ApplicationTypeService applicationTypeService;
    private volatile boolean enabled = false;
    private Element descriptorElement;

    public NavigationLinkModuleDescriptor(ModuleFactory moduleClassFactory, WebInterfaceManager webInterfaceManager, ApplicationWeights applicationWeights, ApplicationTypeService applicationTypeService) {
        super(Objects.requireNonNull(moduleClassFactory), Objects.requireNonNull(webInterfaceManager));
        this.applicationWeights = applicationWeights;
        this.applicationTypeService = applicationTypeService;
    }

    public void init(Plugin plugin, Element element) {
        super.init(plugin, element);
        this.descriptorElement = element;
    }

    protected void validate(Element element) {
        super.validate(element);
        ArrayList<String> errors = new ArrayList<String>();
        if (!element.attributeNames().contains("menu-key")) {
            errors.add("menu-key attribute is mandatory");
        } else if (element.attributeValue("menu-key", "").trim().isEmpty()) {
            errors.add("menu-key is empty");
        }
        if (element.element("link") == null) {
            errors.add("link tag is mandatory");
        } else if (element.elementTextTrim("link").isEmpty()) {
            errors.add("link tag requires a link as content");
        }
        Element labelElement = element.element("label");
        if (labelElement == null) {
            errors.add("label tag is mandatory");
        } else if (labelElement.attributeValue("key", "").trim().isEmpty()) {
            errors.add("label tag requires a key attribute");
        }
        Element tooltipElement = element.element("tooltip");
        if (tooltipElement != null && tooltipElement.attributeValue("key", "").trim().isEmpty()) {
            errors.add("tooltip tag requires a key attribute");
        }
        if (element.element("icon") != null && element.elementTextTrim("icon").isEmpty()) {
            errors.add("icon tag requires an image url as content");
        }
        if (element.element("application-type") != null && element.elementTextTrim("application-type").isEmpty()) {
            errors.add("application-type requires the type name as content");
        }
        if (element.attributeNames().contains("weight")) {
            String weightAttribute = element.attributeValue("weight", "").trim();
            if (weightAttribute.isEmpty()) {
                errors.add("weight attribute must have a value");
            }
            try {
                Integer.parseInt(weightAttribute);
            }
            catch (NumberFormatException e) {
                errors.add("weight attribute must be a number");
            }
        }
        if (!errors.isEmpty()) {
            String moduleKey = element.attributeValue("key");
            throw new ValidationException(String.format("NavigationLinkModuleDescriptor validation errors <navigation-link key=\"%s\"", moduleKey), errors);
        }
    }

    public void enabled() {
        super.enabled();
        this.enabled = true;
    }

    public void disabled() {
        super.disabled();
        this.enabled = false;
    }

    public RawNavigationLink getModule() {
        return this.enabled ? this.parseNavigationLinkEntity() : null;
    }

    private RawNavigationLink parseNavigationLinkEntity() {
        return ((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)new RawNavigationLinkBuilder().key(this.parseMenuKey(this.descriptorElement))).href(this.parseLink(this.descriptorElement.element("link")))).labelKey(this.parseKeyAttributeFromElement(this.descriptorElement.element("label"))).tooltipKey(this.parseKeyAttributeFromElement(this.descriptorElement.element("tooltip"))).iconUrl(this.parseWebIcon(this.descriptorElement.element("icon")))).weight(this.parseWeight())).applicationType(this.parseApplicationType())).self(this.isTrue(this.parseAttribute(this.descriptorElement, "self")))).source(LinkSource.localDefault())).build();
    }

    private String parseMenuKey(Element navigationLinkElement) {
        return this.parseAttribute(navigationLinkElement, "menu-key");
    }

    private String parseLink(@Nullable Element linkElement) {
        return this.parseElementContent(linkElement);
    }

    private String parseKeyAttributeFromElement(@Nullable Element tagElement) {
        return Strings.emptyToNull((String)this.parseAttribute(tagElement, "key"));
    }

    private String parseWebIcon(@Nullable Element iconElement) {
        if (iconElement == null) {
            return null;
        }
        return this.parseElementContent(iconElement);
    }

    private int parseWeight() {
        if (this.descriptorElement.attributeValue("weight") != null) {
            return Integer.parseInt(this.parseAttribute(this.descriptorElement, "weight"));
        }
        return this.applicationWeights.getApplicationWeight();
    }

    private String parseApplicationType() {
        String applicationType = this.parseElementContent(this.descriptorElement.element("application-type"));
        return Strings.isNullOrEmpty((String)applicationType) ? this.applicationTypeService.get() : applicationType;
    }

    private String parseElementContent(@Nullable Element element) {
        String elementContent = element != null ? element.getTextTrim() : null;
        return Strings.nullToEmpty((String)elementContent).trim();
    }

    private String parseAttribute(@Nullable Element element, String attributeName) {
        String attributeValue = element != null ? element.attributeValue(attributeName) : null;
        return Strings.nullToEmpty((String)attributeValue).trim();
    }

    private boolean isTrue(String val) {
        return Boolean.TRUE.toString().equalsIgnoreCase(val);
    }
}

