/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.navigation.rest;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.atlassian.plugins.navlink.producer.navigation.rest.LanguageParameter;
import com.atlassian.plugins.navlink.producer.navigation.services.LocalNavigationLinkService;
import com.atlassian.plugins.navlink.util.CacheControlFactory;
import com.atlassian.plugins.navlink.util.LastModifiedFormatter;
import com.atlassian.plugins.navlink.util.url.BaseUrl;
import com.atlassian.plugins.navlink.util.url.SelfUrl;
import com.atlassian.plugins.navlink.util.url.UrlFactory;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class NavigationServlet
extends HttpServlet {
    static final String INIT_PARAM_CAPABILITIES_REST_ENDPOINT = "capabilitiesRestEndpoint";
    private static final String RESPONSE_TEMPLATE = "com.atlassian.plugins.navlink.navigation";
    private static final String RESOURCE_PATH = "com.atlassian.plugins.atlassian-nav-links-plugin:capabilities-resources";
    private final Logger logger = LoggerFactory.getLogger(NavigationServlet.class);
    private final LocalNavigationLinkService localNavigationLinkService;
    private final SoyTemplateRenderer templateRenderer;
    private final UrlFactory urlFactory;
    private final LocaleResolver localeResolver;
    private String capabilitiesRestEndpoint;

    public NavigationServlet(LocalNavigationLinkService localNavigationLinkService, SoyTemplateRenderer templateRenderer, UrlFactory urlFactory, LocaleResolver localeResolver) {
        this.localNavigationLinkService = localNavigationLinkService;
        this.templateRenderer = templateRenderer;
        this.urlFactory = urlFactory;
        this.localeResolver = localeResolver;
    }

    public void init() throws ServletException {
        this.capabilitiesRestEndpoint = this.getInitParameter(INIT_PARAM_CAPABILITIES_REST_ENDPOINT);
        if (Strings.isNullOrEmpty((String)this.capabilitiesRestEndpoint)) {
            throw new ServletException("init param not specified or empty: 'capabilitiesRestEndpoint'");
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            httpServletResponse.setContentType("application/json");
            httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            httpServletResponse.setHeader("Cache-Control", CacheControlFactory.withConfiguredMaxAgeAndStaleContentExtension().toString());
            httpServletResponse.setHeader("Last-Modified", LastModifiedFormatter.formatCurrentTimeMillis());
            Map<String, Object> context = this.createContext(httpServletRequest);
            PrintWriter writer = httpServletResponse.getWriter();
            this.renderTemplate(context, writer);
        }
        catch (IOException e) {
            this.handleException(httpServletResponse, e);
        }
    }

    private void renderTemplate(@Nonnull Map<String, Object> context, @Nonnull Writer writer) throws IOException {
        this.templateRenderer.render((Appendable)writer, RESOURCE_PATH, RESPONSE_TEMPLATE, context);
    }

    private Map<String, Object> createContext(@Nonnull HttpServletRequest httpServletRequest) {
        BaseUrl baseUrl = this.urlFactory.getCanonicalBaseUrl();
        String selfUrl = SelfUrl.extractFrom(httpServletRequest);
        Locale locale = this.getLocaleFromRequest(httpServletRequest);
        Set<NavigationLink> navigationLinks = this.localNavigationLinkService.all(locale);
        Map<String, List<NavigationLinkHolder>> navigationLinksGroupedByMenuItemKey = this.groupNavigationLinksByKey(navigationLinks);
        return Map.of("baseUrl", baseUrl.resolve("/"), "selfUrl", baseUrl.resolve(selfUrl), "collectionUrl", baseUrl.resolve(this.capabilitiesRestEndpoint), "languageTag", LanguageParameter.encodeValue(locale), "navigationLinks", navigationLinksGroupedByMenuItemKey);
    }

    @Nonnull
    private Locale getLocaleFromRequest(@Nonnull HttpServletRequest httpServletRequest) {
        Locale resolvedLocale;
        Locale defaultLocale = Locale.getDefault();
        Locale requestedLocale = LanguageParameter.extractFrom(httpServletRequest, defaultLocale);
        Locale locale = resolvedLocale = this.localeResolver.getSupportedLocales().contains(requestedLocale) ? requestedLocale : defaultLocale;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Supported locales in this product: {}", (Object)this.localeResolver.getSupportedLocales());
            this.logger.debug("Default locale: {}, Requested locale: {}, Resolved locale: {}", new Object[]{defaultLocale, requestedLocale, resolvedLocale});
        }
        return resolvedLocale;
    }

    @Nonnull
    private Map<String, List<NavigationLinkHolder>> groupNavigationLinksByKey(@Nonnull Set<NavigationLink> navigationLinks) {
        HashMap<String, List<NavigationLinkHolder>> links = new HashMap<String, List<NavigationLinkHolder>>();
        navigationLinks.forEach(navigationLink -> links.computeIfAbsent(navigationLink.getKey(), k -> new LinkedList()).add(new NavigationLinkHolder((NavigationLink)navigationLink)));
        return links;
    }

    private void handleException(@Nonnull HttpServletResponse httpServletResponse, @Nonnull Exception e) {
        this.logger.warn("Failed to serialize navigation items: {}", (Object)e.getMessage());
        this.logger.debug("Stacktrace:", (Throwable)e);
        httpServletResponse.setStatus(500);
    }

    public static final class NavigationLinkHolder {
        private final NavigationLink navigationLink;

        public NavigationLinkHolder(NavigationLink navigationLink) {
            this.navigationLink = navigationLink;
        }

        public String getHref() {
            return this.navigationLink.getHref();
        }

        public String getLabel() {
            return this.navigationLink.getLabel();
        }

        public String getTooltip() {
            return Objects.requireNonNullElse(this.navigationLink.getTooltip(), "");
        }

        public String getIconUrl() {
            return this.navigationLink.getIconUrl();
        }

        public int getWeight() {
            return this.navigationLink.weight();
        }
    }
}

