/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.navigation.services;

import com.atlassian.plugins.navlink.producer.navigation.services.LocalNavigationLinks;
import com.atlassian.plugins.navlink.producer.navigation.services.NavigationLinkRepository;
import com.atlassian.plugins.navlink.producer.navigation.services.NavigationLinkRepositoryService;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLink;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalNavigationLinksImpl
implements LocalNavigationLinks {
    private final Logger logger = LoggerFactory.getLogger(LocalNavigationLinksImpl.class);
    private final NavigationLinkRepositoryService navigationLinkRepositoryService;

    public LocalNavigationLinksImpl(NavigationLinkRepositoryService navigationLinkRepositoryService) {
        this.navigationLinkRepositoryService = navigationLinkRepositoryService;
    }

    @Override
    @Nonnull
    public Set<RawNavigationLink> all() {
        List<NavigationLinkRepository> navigationLinkRepositoryList = this.navigationLinkRepositoryService.getAllNavigationLinkRepositories();
        List navigationLinkEntityList = Lists.transform(navigationLinkRepositoryList, this::getAllLocalNavigationLinks);
        return Sets.newHashSet((Iterable)Iterables.concat((Iterable)navigationLinkEntityList));
    }

    private Iterable<RawNavigationLink> getAllLocalNavigationLinks(NavigationLinkRepository repository) {
        try {
            if (repository != null) {
                return repository.all();
            }
        }
        catch (RuntimeException e) {
            this.logger.warn("Failed to gather navigation links", (Throwable)e);
        }
        return Collections.emptyList();
    }
}

