/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.util.darkfeatures;

import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugins.navlink.util.darkfeatures.DarkFeatureService;
import com.atlassian.webresource.spi.condition.AbstractBooleanUrlReadingCondition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DarkFeatureUrlReadingCondition
extends AbstractBooleanUrlReadingCondition {
    private final DarkFeatureService darkFeatureService;
    private String featureKey;

    public DarkFeatureUrlReadingCondition(DarkFeatureService darkFeatureService) {
        this.darkFeatureService = darkFeatureService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.featureKey = params.get("key");
        if (this.featureKey == null) {
            throw new ValidationException("Failed to initialise condition", (List)ImmutableList.of((Object)"A dark feature 'key' must be provided"));
        }
    }

    protected boolean isConditionTrue() {
        return this.featureKey != null && this.darkFeatureService.isDarkFeatureEnabledForCurrentUser(this.featureKey);
    }

    protected String queryKey() {
        return Optional.ofNullable(this.featureKey).map(fk -> "darkFeature." + fk + ".enabled").orElseThrow(() -> new IllegalPluginStateException(((Object)((Object)this)).getClass().getSimpleName() + "is not initialised."));
    }
}

