/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer;

import jakarta.annotation.Nonnull;
import java.util.Objects;

public class Credential {
    private final String password;
    private final String username;

    private Credential(@Nonnull Builder builder) {
        this.password = builder.password;
        this.username = builder.username;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public static class Builder {
        private final String password;
        private final String username;

        public Builder(@Nonnull String username, @Nonnull String password) {
            this.username = Objects.requireNonNull(username, "username");
            this.password = Objects.requireNonNull(password, "password");
        }

        @Nonnull
        public Credential build() {
            return new Credential(this);
        }
    }
}

