/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalRequestAuthenticationFailedException;
import com.atlassian.bitbucket.internal.importer.ExternalRequestExecutor;
import com.atlassian.bitbucket.internal.importer.ExternalRequestFailedException;
import com.atlassian.bitbucket.internal.importer.ExternalRequestForbiddenException;
import com.atlassian.bitbucket.internal.importer.event.ExternalRequestFailedEvent;
import com.atlassian.bitbucket.internal.importer.event.ExternalRequestForbiddenEvent;
import com.atlassian.bitbucket.internal.importer.event.ExternalRequestUnauthorizedEvent;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.api.DefaultResponseTransformation;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultExternalRequestExecutor
implements ExternalRequestExecutor,
LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultExternalRequestExecutor.class);
    private static final RegexValidator AUTHORITY_VALIDATOR = new RegexValidator("^([\\p{Alnum}\\-\\.]*)(:\\d*)?(.*)?");
    private static final String[] SCHEMES = new String[]{"http", "https"};
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(SCHEMES, AUTHORITY_VALIDATOR, 10L);
    private final EventPublisher eventPublisher;
    private final HttpClient httpClient;
    private final HttpClientFactory httpClientFactory;
    private final I18nService i18nService;

    @Autowired
    public DefaultExternalRequestExecutor(EventPublisher eventPublisher, HttpClientFactory httpClientFactory, I18nService i18nService, ApplicationPropertiesService propertiesService) {
        HttpClientOptions options = new HttpClientOptions();
        options.setSocketTimeout(propertiesService.getPluginProperty("plugin.importer.external.source.request.socket.timeout", 30), TimeUnit.SECONDS);
        options.setRequestTimeout(propertiesService.getPluginProperty("plugin.importer.external.source.request.timeout", 30), TimeUnit.SECONDS);
        options.setSupportedProtocols(new String[]{"TLSv1.2"});
        this.eventPublisher = eventPublisher;
        this.httpClientFactory = httpClientFactory;
        this.httpClient = httpClientFactory.create(options);
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    public <T> T executeGetRequest(@Nonnull Credential credential, @Nonnull String url, @Nonnull Function<Response, T> parser) {
        return this.executeHttpRequest(credential, url, parser, Request.Builder::get);
    }

    @Override
    @Nonnull
    public <T> T executeGetRequest(@Nonnull Credential credential, @Nonnull String url, @Nonnull Function<Response, T> parser, @Nonnull Function<Response, T> errorHandler) {
        return this.executeHttpRequest(credential, url, parser, Request.Builder::get, errorHandler);
    }

    @Override
    @Nonnull
    public <T> T executeHeadRequest(@Nonnull Credential credential, @Nonnull String url, @Nonnull Function<Response, T> parser) {
        return this.executeHttpRequest(credential, url, parser, builder -> builder.setCacheDisabled().head());
    }

    public void onStart() {
    }

    public void onStop() {
        try {
            this.httpClientFactory.dispose(this.httpClient);
        }
        catch (Exception e) {
            log.warn("Failed to dispose a HttpClient");
            log.debug("Dispose error:", (Throwable)e);
        }
    }

    private <T> T executeHttpRequest(@Nonnull Credential credential, @Nonnull String url, @Nonnull Function<Response, T> parser, @Nonnull Function<Request.Builder, ResponsePromise> httpMethod) {
        return (T)this.executeHttpRequest(credential, url, parser, httpMethod, response -> {
            this.eventPublisher.publish((Object)new ExternalRequestFailedEvent(this, response.getStatusCode()));
            throw new ExternalRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.importer.external.request.failed.errorcode", new Object[]{response.getStatusCode(), response.getStatusText()}));
        });
    }

    @Nonnull
    private <T> T executeHttpRequest(@Nonnull Credential credential, @Nonnull String url, @Nonnull Function<Response, T> parser, @Nonnull Function<Request.Builder, ResponsePromise> httpMethod, @Nonnull Function<Response, T> errorHandler) {
        if (!URL_VALIDATOR.isValid(url)) {
            throw new ExternalRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.importer.external.request.invalid.url", new Object[]{url}));
        }
        String authString = credential.getUsername() + ":" + credential.getPassword();
        String encodedAuthString = Base64.encodeBase64String((byte[])authString.getBytes(StandardCharsets.UTF_8));
        Request.Builder builder = this.httpClient.newRequest(url).setAccept("application/json").setHeader("Authorization", "Basic " + encodedAuthString);
        return (T)httpMethod.apply(builder).transform((ResponseTransformation)DefaultResponseTransformation.builder().ok(parser::apply).unauthorized(response -> {
            this.eventPublisher.publish((Object)new ExternalRequestUnauthorizedEvent(this, response.getStatusCode()));
            throw new ExternalRequestAuthenticationFailedException(this.i18nService.createKeyedMessage("bitbucket.importer.external.request.authentication.failed", new Object[0]));
        }).forbidden(response -> {
            this.eventPublisher.publish((Object)new ExternalRequestForbiddenEvent(this, response.getStatusCode()));
            throw new ExternalRequestForbiddenException(this.i18nService.createKeyedMessage("bitbucket.importer.external.request.forbidden", new Object[0]));
        }).others(errorHandler::apply).fail(e -> {
            if (e instanceof ServiceException) {
                throw (ServiceException)((Object)e);
            }
            log.debug("External request failed", e);
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            throw new ExternalRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.importer.external.request.failed.errormessage", new Object[]{rootCause.getLocalizedMessage()}), rootCause);
        }).build()).claim();
    }
}

