/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.importer.ExternalOwner;
import com.atlassian.bitbucket.internal.importer.ExternalOwnerSearchRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRepository;
import com.atlassian.bitbucket.internal.importer.ExternalRepositorySearchRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRepositoryService;
import com.atlassian.bitbucket.internal.importer.ExternalRequest;
import com.atlassian.bitbucket.internal.importer.ExternalUser;
import com.atlassian.bitbucket.internal.importer.OAuthScope;
import com.atlassian.bitbucket.internal.importer.SourceType;
import com.atlassian.bitbucket.internal.importer.UnsupportedSourceException;
import com.atlassian.bitbucket.internal.importer.event.ExternalOwnerSearchEvent;
import com.atlassian.bitbucket.internal.importer.event.ExternalRepositorySearchEvent;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DelegatingRepositoryService
implements ExternalRepositoryService {
    private final EventPublisher eventPublisher;
    private final Map<String, ExternalRepositoryService> externalRepositoryServices;
    private final I18nService i18nService;

    public DelegatingRepositoryService(@Nonnull EventPublisher eventPublisher, @Nonnull Map<String, ExternalRepositoryService> externalRepositoryServices, @Nonnull I18nService i18nService) {
        this.eventPublisher = eventPublisher;
        this.externalRepositoryServices = externalRepositoryServices;
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    public Set<OAuthScope> getMissingOAuthScopes(ExternalRequest request) {
        SourceType sourceType = Objects.requireNonNull(request, "request").getSource().getType();
        return this.getExternalSource(sourceType).getMissingOAuthScopes(request);
    }

    @Override
    @Nonnull
    public ExternalUser getUser(@Nonnull ExternalRequest request) {
        SourceType sourceType = Objects.requireNonNull(request, "request").getSource().getType();
        return this.getExternalSource(sourceType).getUser(request);
    }

    @Override
    @Nonnull
    public Page<ExternalOwner> searchOwners(@Nonnull ExternalOwnerSearchRequest request, @Nonnull PageRequest pageRequest) {
        SourceType sourceType = Objects.requireNonNull(request, "request").getSource().getType();
        Objects.requireNonNull(pageRequest, "pageRequest");
        Page<ExternalOwner> page = this.getExternalSource(sourceType).searchOwners(request, pageRequest);
        this.eventPublisher.publish((Object)new ExternalOwnerSearchEvent(this, sourceType, page.getSize(), page.getStart(), page.getIsLastPage()));
        return page;
    }

    @Override
    @Nonnull
    public Page<ExternalRepository> searchRepositories(@Nonnull ExternalRepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        SourceType sourceType = Objects.requireNonNull(request, "request").getSource().getType();
        Objects.requireNonNull(pageRequest, "pageRequest");
        Page<ExternalRepository> page = this.getExternalSource(sourceType).searchRepositories(request, pageRequest);
        this.eventPublisher.publish((Object)new ExternalRepositorySearchEvent(this, sourceType, page.getSize(), page.getStart(), page.getIsLastPage()));
        return page;
    }

    private ExternalRepositoryService getExternalSource(SourceType sourceType) {
        ExternalRepositoryService externalRepositoryService = this.externalRepositoryServices.get(sourceType.name());
        if (externalRepositoryService == null) {
            throw new UnsupportedSourceException(this.i18nService.createKeyedMessage("bitbucket.importer.unsupported.sourcetype", new Object[]{sourceType.name()}));
        }
        return externalRepositoryService;
    }
}

