/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer;

import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalRequest;
import com.atlassian.bitbucket.internal.importer.ExternalSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ExternalRepositorySearchRequest
extends ExternalRequest {
    private final Optional<String> filter;
    private final Optional<String> ownerName;

    private ExternalRepositorySearchRequest(@Nonnull Builder builder) {
        super(builder);
        this.filter = builder.filter;
        this.ownerName = builder.ownerName;
    }

    @Nonnull
    public Optional<String> getFilter() {
        return this.filter;
    }

    @Nonnull
    public Optional<String> getOwnerName() {
        return this.ownerName;
    }

    public static class Builder
    extends ExternalRequest.Builder {
        private Optional<String> filter = Optional.empty();
        private Optional<String> ownerName = Optional.empty();

        public Builder(@Nonnull Credential credential, @Nonnull ExternalSource source) {
            super(credential, source);
        }

        @Override
        @Nonnull
        public ExternalRepositorySearchRequest build() {
            return new ExternalRepositorySearchRequest(this);
        }

        @Nonnull
        public Builder filter(@Nullable String value) {
            this.filter = Optional.ofNullable(StringUtils.stripToNull((String)value));
            return this;
        }

        @Nonnull
        public Builder ownerName(@Nullable String value) {
            this.ownerName = Optional.ofNullable(StringUtils.stripToNull((String)value));
            return this;
        }
    }
}

