/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer;

import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalSource;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ExternalRequest {
    private final Credential credential;
    private final ExternalSource source;

    protected ExternalRequest(@Nonnull Builder builder) {
        this.credential = builder.credential;
        this.source = builder.source;
    }

    @Nonnull
    public Credential getCredential() {
        return this.credential;
    }

    @Nonnull
    public ExternalSource getSource() {
        return this.source;
    }

    public static class Builder {
        private final Credential credential;
        private final ExternalSource source;

        public Builder(@Nonnull Credential credential, @Nonnull ExternalSource source) {
            this.credential = Objects.requireNonNull(credential, "credential");
            this.source = Objects.requireNonNull(source, "source");
        }

        @Nonnull
        public ExternalRequest build() {
            return new ExternalRequest(this);
        }
    }
}

