/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer;

import com.atlassian.bitbucket.internal.importer.SourceType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ExternalSource {
    private final SourceType type;
    private final Optional<String> url;

    private ExternalSource(Builder builder) {
        this.type = builder.type;
        this.url = builder.url;
    }

    public SourceType getType() {
        return this.type;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public static class Builder {
        private SourceType type;
        private Optional<String> url = Optional.empty();

        public Builder(@Nonnull SourceType type) {
            this.type = Objects.requireNonNull(type, "type");
        }

        public ExternalSource build() {
            return new ExternalSource(this);
        }

        public Builder url(@Nullable String value) {
            this.url = Optional.ofNullable(StringUtils.stripToNull((String)value));
            return this;
        }
    }
}

