/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.bitbucketcloud;

import com.atlassian.bitbucket.internal.importer.OAuthScope;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum BitbucketCloudOAuthScope {
    ORG(OAuthScope.OWNER, (List<String>)ImmutableList.of((Object)"team", (Object)"team:write")),
    REPO(OAuthScope.REPOSITORY, (List<String>)ImmutableList.of((Object)"repository", (Object)"repository:write", (Object)"repository:admin", (Object)"project"));

    private final OAuthScope scope;
    private final List<String> allowedScopes;

    private BitbucketCloudOAuthScope(OAuthScope scope, List<String> allowedScopes) {
        this.scope = scope;
        this.allowedScopes = allowedScopes;
    }

    public OAuthScope getScope() {
        return this.scope;
    }

    public static Optional<BitbucketCloudOAuthScope> fromString(String value) {
        return Arrays.stream(BitbucketCloudOAuthScope.values()).filter(scope -> scope.allowedScopes.contains(value)).findFirst();
    }
}

