/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.bitbucketcloud;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalOwner;
import com.atlassian.bitbucket.internal.importer.ExternalOwnerSearchRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRepository;
import com.atlassian.bitbucket.internal.importer.ExternalRepositorySearchRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRepositoryService;
import com.atlassian.bitbucket.internal.importer.ExternalRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRequestExecutor;
import com.atlassian.bitbucket.internal.importer.ExternalRequestFailedException;
import com.atlassian.bitbucket.internal.importer.ExternalUser;
import com.atlassian.bitbucket.internal.importer.OAuthScope;
import com.atlassian.bitbucket.internal.importer.bitbucketcloud.BitbucketCloudOAuthScope;
import com.atlassian.bitbucket.internal.importer.bitbucketcloud.BitbucketCloudRepositoryResponse;
import com.atlassian.bitbucket.internal.importer.bitbucketcloud.BitbucketCloudUriBuilder;
import com.atlassian.bitbucket.internal.importer.bitbucketcloud.BitbucketCloudUser;
import com.atlassian.bitbucket.internal.importer.bitbucketcloud.BitbucketCloudWorkspaceResponse;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.httpclient.api.Response;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.validation.Validator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BitbucketCloudRepositoryService
implements ExternalRepositoryService {
    private static final Logger log = LoggerFactory.getLogger(BitbucketCloudRepositoryService.class);
    private final String bbCloudApiUrl;
    private final I18nService i18nService;
    private final ExternalRequestExecutor requestExecutor;
    private final Validator validator;

    @Autowired
    public BitbucketCloudRepositoryService(I18nService i18nService, ApplicationPropertiesService propertiesService, ExternalRequestExecutor requestExecutor, Validator validator) {
        this.i18nService = i18nService;
        this.requestExecutor = requestExecutor;
        this.validator = validator;
        this.bbCloudApiUrl = propertiesService.getPluginProperty("plugin.importer.bitbucketcloud.api.url", "https://api.bitbucket.org/2.0");
    }

    @Override
    @Nonnull
    public Set<OAuthScope> getMissingOAuthScopes(@Nonnull ExternalRequest request) {
        Set oAuthScopes = this.requestExecutor.executeHeadRequest(request.getCredential(), BitbucketCloudUriBuilder.buildUserUrl(this.bbCloudApiUrl), response -> {
            String scopes = response.getHeader("X-OAuth-Scopes");
            if (StringUtils.isBlank((CharSequence)scopes)) {
                return Collections.emptySet();
            }
            return Arrays.stream(scopes.split(",")).map(String::trim).map(BitbucketCloudOAuthScope::fromString).filter(Optional::isPresent).map(Optional::get).map(BitbucketCloudOAuthScope::getScope).collect(Collectors.toSet());
        });
        return Sets.difference((Set)CollectionHelper.asSet((Object[])OAuthScope.values()), (Set)oAuthScopes);
    }

    @Override
    @Nonnull
    public ExternalUser getUser(ExternalRequest request) {
        return this.requestExecutor.executeGetRequest(request.getCredential(), BitbucketCloudUriBuilder.buildUserUrl(this.bbCloudApiUrl), response -> {
            String responseEntity = this.getResponseEntity((Response)response);
            try {
                return (BitbucketCloudUser)ValidationUtils.validate((Validator)this.validator, (Object)((BitbucketCloudUser)new ObjectMapper().readValue(responseEntity, BitbucketCloudUser.class)), (Class[])new Class[0]);
            }
            catch (IOException e) {
                throw this.newExternalRequestFailedException();
            }
        });
    }

    @Override
    @Nonnull
    public Page<ExternalOwner> searchOwners(@Nonnull ExternalOwnerSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Page page = this.requestExecutor.executeGetRequest(request.getCredential(), BitbucketCloudUriBuilder.buildWorkspacesSearchUrl(this.bbCloudApiUrl, pageRequest), response -> {
            String responseEntity = this.getResponseEntity((Response)response);
            try {
                BitbucketCloudWorkspaceResponse workspaceResponse = (BitbucketCloudWorkspaceResponse)((Object)((Object)ValidationUtils.validate((Validator)this.validator, (Object)((Object)((BitbucketCloudWorkspaceResponse)((Object)((Object)new ObjectMapper().readValue(responseEntity, BitbucketCloudWorkspaceResponse.class))))), (Class[])new Class[0])));
                if (workspaceResponse == null || workspaceResponse.isEmpty()) {
                    throw this.newExternalRequestFailedException();
                }
                List workspaces = workspaceResponse.getValues().stream().filter(Objects::nonNull).collect(Collectors.toList());
                return PageUtils.createPage(workspaces, (boolean)workspaceResponse.isLastPage(), (PageRequest)pageRequest);
            }
            catch (IOException e) {
                log.warn("Failed to deserialize response from the external repository source", (Throwable)e);
                throw this.newExternalRequestFailedException();
            }
        });
        return PageUtils.asPageOf(ExternalOwner.class, (Page)page);
    }

    @Override
    @Nonnull
    public Page<ExternalRepository> searchRepositories(@Nonnull ExternalRepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Credential credential = request.getCredential();
        Page page = this.requestExecutor.executeGetRequest(credential, BitbucketCloudUriBuilder.buildRepositoriesSearchUrl(this.bbCloudApiUrl, request, pageRequest), response -> {
            String responseEntity = this.getResponseEntity((Response)response);
            try {
                BitbucketCloudRepositoryResponse repositoryResponse = (BitbucketCloudRepositoryResponse)((Object)((Object)ValidationUtils.validate((Validator)this.validator, (Object)((Object)((BitbucketCloudRepositoryResponse)((Object)((Object)new ObjectMapper().readValue(responseEntity, BitbucketCloudRepositoryResponse.class))))), (Class[])new Class[0])));
                if (repositoryResponse == null || repositoryResponse.isEmpty()) {
                    throw this.newExternalRequestFailedException();
                }
                List repositories = repositoryResponse.getValues().stream().filter(Objects::nonNull).collect(Collectors.toList());
                return PageUtils.createPage(repositories, (boolean)repositoryResponse.isLastPage(), (PageRequest)pageRequest);
            }
            catch (IOException e) {
                log.warn("Failed to deserialize response from the external repository source", (Throwable)e);
                throw this.newExternalRequestFailedException();
            }
        });
        return PageUtils.asPageOf(ExternalRepository.class, (Page)page);
    }

    private String getResponseEntity(Response response) {
        String responseEntity = response.getEntity();
        if (responseEntity == null || responseEntity.isEmpty()) {
            this.newExternalRequestFailedException();
        }
        return responseEntity;
    }

    private ExternalRequestFailedException newExternalRequestFailedException() {
        throw new ExternalRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.importer.external.request.failed", new Object[0]));
    }
}

