/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.bitbucketcloud;

import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalRepositorySearchRequest;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.UrlUtils;
import java.net.URI;
import org.apache.http.client.utils.URIBuilder;

public class BitbucketCloudUriBuilder {
    private static final String PAGE_NUMBER = "page";
    private static final String PAGE_SIZE = "pagelen";
    private static final String QUERY = "q";
    private final URIBuilder uriBuilder;

    private BitbucketCloudUriBuilder(String baseUrl, String path) {
        this.uriBuilder = new URIBuilder(URI.create(baseUrl + "/" + path));
    }

    private BitbucketCloudUriBuilder(String baseUrl, String path, PageRequest pageRequest) {
        this(baseUrl, path);
        this.pageNumber(this.getPageNumber(pageRequest));
        this.pageSize(pageRequest.getLimit());
    }

    public static String buildWorkspacesSearchUrl(String baseUrl, PageRequest pageRequest) {
        return new BitbucketCloudUriBuilder(baseUrl, "workspaces", pageRequest).build();
    }

    public static String buildRepositoriesSearchUrl(String baseUrl, ExternalRepositorySearchRequest request, PageRequest pageRequest) {
        Credential credential = request.getCredential();
        String workspaceId = UrlUtils.encodeURL((String)request.getOwnerName().orElseGet(credential::getUsername));
        BitbucketCloudUriBuilder uriBuilder = new BitbucketCloudUriBuilder(baseUrl, "repositories/" + workspaceId, pageRequest);
        return uriBuilder.build();
    }

    public static String buildUserUrl(String baseUrl) {
        return new BitbucketCloudUriBuilder(baseUrl, "user").build();
    }

    private BitbucketCloudUriBuilder pageNumber(int pageNumber) {
        this.uriBuilder.addParameter(PAGE_NUMBER, String.valueOf(pageNumber));
        return this;
    }

    private BitbucketCloudUriBuilder pageSize(int pageSize) {
        this.uriBuilder.addParameter(PAGE_SIZE, String.valueOf(pageSize));
        return this;
    }

    private BitbucketCloudUriBuilder addQuery(String query) {
        this.uriBuilder.addParameter(QUERY, query);
        return this;
    }

    private String build() {
        return this.uriBuilder.toString();
    }

    private int getPageNumber(PageRequest pageRequest) {
        return pageRequest.getStart() / pageRequest.getLimit() + 1;
    }
}

