/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.importer.dao.AoImportJob;
import com.atlassian.bitbucket.internal.importer.dao.AoRepositoryImportTask;
import com.atlassian.bitbucket.internal.importer.dao.ImporterDao;
import com.atlassian.bitbucket.internal.importer.repository.ImportJob;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskFailureType;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskState;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTask;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.java.ao.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AoImporterDao
extends AbstractAoDao
implements ImporterDao {
    private final RepositoryService repositoryService;

    @Autowired
    public AoImporterDao(ActiveObjects ao, RepositoryService repositoryService) {
        super(ao);
        this.repositoryService = repositoryService;
    }

    @Override
    @Nonnull
    public RepositoryImportTask createImportTask(long jobId, @Nonnull String cloneUrl, @Nonnull String externalRepoName, @Nonnull ImportTaskFailureType failureType, int repositoryId, @Nonnull ImportTaskState state) {
        this.checkStateProconditions(state, failureType);
        ImmutableMap.Builder taskBuilder = ImmutableMap.builder();
        taskBuilder.put((Object)"IMPORT_JOB_ID", (Object)jobId).put((Object)"CLONE_URL", (Object)cloneUrl).put((Object)"CREATED_DATE", (Object)new Date()).put((Object)"EXTERNAL_REPO_NAME", (Object)Objects.requireNonNull(externalRepoName, "externalRepoName")).put((Object)"LAST_UPDATED", (Object)new Date()).put((Object)"REPOSITORY_ID", (Object)repositoryId).put((Object)"STATE", (Object)state.getId()).put((Object)"FAILURE_TYPE", (Object)failureType.getId());
        return this.getRepositoryImportTask((AoRepositoryImportTask)this.ao.create(AoRepositoryImportTask.class, (Map)taskBuilder.build()));
    }

    @Override
    @Nonnull
    public ImportJob createJob(int userId) {
        AoImportJob aoImportJob = (AoImportJob)this.ao.create(AoImportJob.class, (Map)ImmutableMap.of((Object)"USER_ID", (Object)userId, (Object)"CREATED_DATE", (Object)new Date()));
        return new ImportJob.Builder(aoImportJob).build();
    }

    @Override
    @Nonnull
    public Optional<RepositoryImportTask> getImportTask(@Nonnull Repository repository) {
        AoRepositoryImportTask[] importTasks = (AoRepositoryImportTask[])this.ao.find(AoRepositoryImportTask.class, Query.select().where("REPOSITORY_ID = ?", new Object[]{repository.getId()}));
        if (importTasks.length > 0) {
            AoRepositoryImportTask importTask = importTasks[0];
            return Optional.of(this.getRepositoryImportTask(importTask));
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ImportJob> getJob(long jobId) {
        AoImportJob aoImportJob = (AoImportJob)this.ao.get(AoImportJob.class, (Object)jobId);
        if (aoImportJob != null) {
            List<RepositoryImportTask> importTasks = Arrays.stream(aoImportJob.getRepositoryImportTasks()).map(this::getRepositoryImportTask).collect(Collectors.toList());
            return Optional.of(new ImportJob.Builder(aoImportJob).tasks(importTasks).build());
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public List<RepositoryImportTask> getUnfinishedTasks() {
        Query query = Query.select().where("STATE = ? OR STATE= ?", new Object[]{ImportTaskState.QUEUED.getId(), ImportTaskState.STARTED.getId()});
        return Arrays.stream((AoRepositoryImportTask[])this.ao.find(AoRepositoryImportTask.class, query)).map(this::getRepositoryImportTask).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public RepositoryImportTask updateImportTaskState(long taskId, @Nonnull ImportTaskState state, @Nonnull ImportTaskFailureType failureType) {
        this.checkStateProconditions(state, failureType);
        AoRepositoryImportTask repositoryImportTask = (AoRepositoryImportTask)this.ao.get(AoRepositoryImportTask.class, (Object)taskId);
        repositoryImportTask.setLastUpdatedDate(new Date());
        repositoryImportTask.setState(state);
        repositoryImportTask.setFailureType(failureType);
        repositoryImportTask.save();
        return this.getRepositoryImportTask(repositoryImportTask);
    }

    private void checkStateProconditions(ImportTaskState state, ImportTaskFailureType failureType) {
        Objects.requireNonNull(state, "state");
        Objects.requireNonNull(failureType, "failureType");
        if (state == ImportTaskState.FAILED) {
            Preconditions.checkArgument((failureType != ImportTaskFailureType.NONE ? 1 : 0) != 0, (Object)"A failure type != NONE is required when state == FAILED");
        } else {
            Preconditions.checkArgument((failureType == ImportTaskFailureType.NONE ? 1 : 0) != 0, (Object)"A failure type == NONE is required when state != FAILED");
        }
    }

    @Nonnull
    private RepositoryImportTask getRepositoryImportTask(AoRepositoryImportTask aoRepositoryImportTask) {
        return new RepositoryImportTask.Builder(this.repositoryService.getById(aoRepositoryImportTask.getRepositoryId()), aoRepositoryImportTask).build();
    }
}

