/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.github;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractUrlBuilder<T> {
    private final String defaultBaseUrl;
    private String url;

    protected AbstractUrlBuilder(@Nonnull String defaultBaseUrl) {
        this.defaultBaseUrl = Objects.requireNonNull(defaultBaseUrl, "defaultBaseUrl");
    }

    @Nonnull
    protected abstract T self();

    @Nonnull
    public T url(@Nullable String value) {
        this.url = StringUtils.stripToNull((String)value);
        return this.self();
    }

    @Nonnull
    protected String base() {
        return this.url != null ? this.url + "/api/v3" : this.defaultBaseUrl;
    }
}

