/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.github;

import com.atlassian.bitbucket.internal.importer.OAuthScope;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum GitHubOAuthScope {
    ORG(OAuthScope.OWNER, (List<String>)ImmutableList.of((Object)"read:org", (Object)"write:org", (Object)"admin:org")),
    REPO(OAuthScope.REPOSITORY, (List<String>)ImmutableList.of((Object)"repo"));

    private final OAuthScope scope;
    private final List<String> allowedScopes;

    private GitHubOAuthScope(OAuthScope scope, List<String> allowedScopes) {
        this.scope = scope;
        this.allowedScopes = allowedScopes;
    }

    public OAuthScope getScope() {
        return this.scope;
    }

    public static Optional<GitHubOAuthScope> fromString(String value) {
        return Arrays.stream(GitHubOAuthScope.values()).filter(scope -> scope.allowedScopes.contains(value)).findFirst();
    }
}

