/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.github;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalOwner;
import com.atlassian.bitbucket.internal.importer.ExternalOwnerSearchRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRepository;
import com.atlassian.bitbucket.internal.importer.ExternalRepositorySearchRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRepositoryService;
import com.atlassian.bitbucket.internal.importer.ExternalRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRequestExecutor;
import com.atlassian.bitbucket.internal.importer.ExternalRequestFailedException;
import com.atlassian.bitbucket.internal.importer.ExternalUser;
import com.atlassian.bitbucket.internal.importer.OAuthScope;
import com.atlassian.bitbucket.internal.importer.event.ExternalRequestFailedEvent;
import com.atlassian.bitbucket.internal.importer.github.GitHubOAuthScope;
import com.atlassian.bitbucket.internal.importer.github.GitHubOrganization;
import com.atlassian.bitbucket.internal.importer.github.GitHubRepository;
import com.atlassian.bitbucket.internal.importer.github.GitHubUrlBuilder;
import com.atlassian.bitbucket.internal.importer.github.GitHubUser;
import com.atlassian.bitbucket.internal.importer.github.OrganizationsUrlBuilder;
import com.atlassian.bitbucket.internal.importer.github.RepositorySearchUrlBuilder;
import com.atlassian.bitbucket.internal.importer.github.UserUrlBuilder;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.api.Response;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Validator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GitHubRepositoryService
implements ExternalRepositoryService {
    private static final Logger log = LoggerFactory.getLogger(GitHubRepositoryService.class);
    private static final String X_OAUTH_SCOPES_HEADER = "X-OAuth-Scopes";
    private final EventPublisher eventPublisher;
    private final GitHubUrlBuilder gitHubUrlBuilder;
    private final I18nService i18nService;
    private final ExternalRequestExecutor requestExecutor;
    private final Validator validator;

    @Autowired
    public GitHubRepositoryService(EventPublisher eventPublisher, I18nService i18nService, ApplicationPropertiesService propertiesService, ExternalRequestExecutor requestExecutor, Validator validator) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.requestExecutor = requestExecutor;
        this.validator = validator;
        this.gitHubUrlBuilder = new GitHubUrlBuilder(propertiesService.getPluginProperty("plugin.importer.github.api.url", "https://api.github.com"));
    }

    @Override
    @Nonnull
    public Set<OAuthScope> getMissingOAuthScopes(@Nonnull ExternalRequest request) {
        UserUrlBuilder userUrlBuilder = this.gitHubUrlBuilder.user(request.getCredential().getUsername());
        request.getSource().getUrl().ifPresent(userUrlBuilder::url);
        return this.requestExecutor.executeHeadRequest(request.getCredential(), userUrlBuilder.build(), GitHubRepositoryService::parseResponseToOAuthScopes).map(oAuthScopes -> this.diff(CollectionHelper.asSet((Object[])OAuthScope.values()), (Set)oAuthScopes)).orElse(Collections.emptySet());
    }

    @Override
    @Nonnull
    public ExternalUser getUser(ExternalRequest request) {
        UserUrlBuilder userUrlBuilder = this.gitHubUrlBuilder.user(request.getCredential().getUsername());
        request.getSource().getUrl().ifPresent(userUrlBuilder::url);
        return (ExternalUser)this.requestExecutor.executeGetRequest(request.getCredential(), userUrlBuilder.build(), this.responseParser(response -> this.parseEntity((Class)GitHubUser.class, (Response)response)));
    }

    @Override
    @Nonnull
    public Page<ExternalOwner> searchOwners(@Nonnull ExternalOwnerSearchRequest request, @Nonnull PageRequest pageRequest) {
        OrganizationsUrlBuilder urlBuilder = this.gitHubUrlBuilder.userOrganizations(pageRequest);
        Objects.requireNonNull(request, "request").getSource().getUrl().ifPresent(urlBuilder::url);
        return (Page)this.requestExecutor.executeGetRequest(request.getCredential(), urlBuilder.build(), this.responseParser(response -> this.parsePage((Class)GitHubOrganization.class, pageRequest, Function.identity(), (Response)response)));
    }

    @Override
    @Nonnull
    public Page<ExternalRepository> searchRepositories(@Nonnull ExternalRepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        RepositorySearchUrlBuilder urlBuilder = this.gitHubUrlBuilder.repositorySearch(pageRequest);
        Objects.requireNonNull(request, "request").getSource().getUrl().ifPresent(urlBuilder::url);
        Credential credential = request.getCredential();
        request.getFilter().ifPresent(filter -> urlBuilder.filter(filter + "+in", "name,description"));
        urlBuilder.filter("user", request.getOwnerName().orElseGet(credential::getUsername));
        urlBuilder.filter("fork", Boolean.toString(true));
        return this.requestExecutor.executeGetRequest(credential, urlBuilder.build(), this.responseParser(response -> this.parsePage((Class)GitHubRepository.class, pageRequest, node -> node.get("items"), (Response)response)), response -> {
            if (response.getStatusCode() == 422) {
                return PageUtils.createEmptyPage((PageRequest)pageRequest);
            }
            this.eventPublisher.publish((Object)new ExternalRequestFailedEvent(this, response.getStatusCode()));
            throw new ExternalRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.importer.external.request.failed.errorcode", new Object[]{response.getStatusCode(), response.getStatusText()}));
        });
    }

    private <T> Set<T> diff(Set<T> s1, Set<T> s2) {
        return Sets.difference(s1, s2);
    }

    private <T, R extends T> Optional<Page<T>> parsePage(Class<R> type, PageRequest pageRequest, Function<JsonNode, JsonNode> function, Response response) {
        String entity = response.getEntity();
        if (StringUtils.isBlank((CharSequence)entity)) {
            log.warn("The external repository source responded with status code {} but the response entity was empty", (Object)response.getStatusCode());
            return Optional.empty();
        }
        String link = response.getHeader("Link");
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode page = mapper.readTree(entity);
            if (page.isNull()) {
                log.warn("The response from the external repository source is not a JSON object");
                return Optional.empty();
            }
            JsonNode valuesNode = function.apply(page);
            if (valuesNode == null || valuesNode.isNull()) {
                log.warn("The response from the external repository source is not in a proper JSON format");
                return Optional.empty();
            }
            ImmutableList.Builder values = ImmutableList.builder();
            for (JsonNode node : valuesNode) {
                values.add(ValidationUtils.validate((Validator)this.validator, (Object)mapper.treeToValue((TreeNode)node, type), (Class[])new Class[0]));
            }
            return Optional.of(PageUtils.createPage((Iterable)values.build(), (!StringUtils.contains((CharSequence)link, (CharSequence)"rel=\"next\"") ? 1 : 0) != 0, (PageRequest)pageRequest));
        }
        catch (IOException e) {
            log.warn("Failed to deserialize response from the external repository source", (Throwable)e);
            return Optional.empty();
        }
    }

    private <T, R extends T> Optional<T> parseEntity(Class<R> type, Response response) {
        String entity = response.getEntity();
        if (StringUtils.isBlank((CharSequence)entity)) {
            log.warn("The external repository source responded with status code {} but the response entity was empty", (Object)response.getStatusCode());
            return Optional.empty();
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return Optional.of(ValidationUtils.validate((Validator)this.validator, (Object)mapper.readValue(entity, type), (Class[])new Class[0]));
        }
        catch (IOException e) {
            log.warn("Failed to deserialize response from the external repository source", (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<Set<OAuthScope>> parseResponseToOAuthScopes(Response response) {
        String scopes = response.getHeader(X_OAUTH_SCOPES_HEADER);
        if (scopes == null) {
            return Optional.empty();
        }
        return Optional.of(Arrays.stream(scopes.split(",")).map(GitHubRepositoryService::toNullableOAuthScope).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    private <T> Function<Response, T> responseParser(Function<Response, Optional<T>> parser) {
        return response -> ((Optional)parser.apply((Response)response)).orElseThrow(() -> new ExternalRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.importer.external.request.failed.errorcode", new Object[]{response.getStatusCode(), response.getStatusText()})));
    }

    @Nullable
    private static OAuthScope toNullableOAuthScope(@Nonnull String value) {
        return GitHubOAuthScope.fromString(value.trim()).map(GitHubOAuthScope::getScope).orElse(null);
    }
}

