/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.github;

import com.atlassian.bitbucket.internal.importer.ExternalUser;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
@JsonSurrogate(value=ExternalUser.class)
public class GitHubUser
extends RestMapEntity
implements ExternalUser {
    public static final String AVATAR_URL = "avatar_url";
    public static final String NAME = "name";
    public static final String LOGIN = "login";

    @Override
    @Nonnull
    public String getAvatarUrl() {
        return this.getStringProperty(AVATAR_URL);
    }

    @Override
    @Nonnull
    public String getDescription() {
        String nameValue = this.getStringProperty(NAME);
        return this.getStringProperty(LOGIN) + (StringUtils.isBlank((CharSequence)nameValue) ? "" : String.format(" (%s)", nameValue));
    }

    @Nonnull
    @NotNull
    public String getLogin() {
        return this.getStringProperty(LOGIN);
    }

    @Override
    @Nonnull
    @NotNull
    public String getName() {
        return this.getLogin();
    }
}

