/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.github;

import com.atlassian.bitbucket.internal.importer.github.AbstractPageUrlBuilder;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class RepositorySearchUrlBuilder
extends AbstractPageUrlBuilder<RepositorySearchUrlBuilder> {
    private final ImmutableMap.Builder<String, String> filter = ImmutableMap.builder();

    protected RepositorySearchUrlBuilder(@Nonnull String defaultBaseUrl, @Nonnull PageRequest pageRequest) {
        super(defaultBaseUrl, pageRequest);
    }

    public String build() {
        StringBuilder url = new StringBuilder(this.base());
        url.append("/search/repositories?");
        url.append("q=");
        this.filter.build().entrySet().forEach(entry -> {
            url.append((String)entry.getKey());
            url.append(':');
            url.append((String)entry.getValue());
            url.append('+');
        });
        url.append('&');
        url.append(this.pageParameters());
        return url.toString();
    }

    @Nonnull
    public RepositorySearchUrlBuilder filter(@Nonnull String key, @Nonnull String value) {
        this.filter.put((Object)Objects.requireNonNull(key, "key"), (Object)Objects.requireNonNull(value, "value"));
        return this;
    }

    @Override
    public RepositorySearchUrlBuilder self() {
        return this;
    }
}

