/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.repository;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalOwner;
import com.atlassian.bitbucket.internal.importer.ExternalRepository;
import com.atlassian.bitbucket.internal.importer.ExternalRepositorySearchRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRepositoryService;
import com.atlassian.bitbucket.internal.importer.UnsupportedScmForImportException;
import com.atlassian.bitbucket.internal.importer.dao.ImporterDao;
import com.atlassian.bitbucket.internal.importer.event.ImportJobCreatedEvent;
import com.atlassian.bitbucket.internal.importer.repository.ExecutorFactory;
import com.atlassian.bitbucket.internal.importer.repository.ImportJob;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskFailureType;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskState;
import com.atlassian.bitbucket.internal.importer.repository.OwnerImportRequest;
import com.atlassian.bitbucket.internal.importer.repository.RefSyncTaskFactory;
import com.atlassian.bitbucket.internal.importer.repository.RepositoriesImportRequest;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportService;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTask;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTaskHelper;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCreateRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.AvailableScm;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRepositoryImportService
implements RepositoryImportService,
LifecycleAware {
    @VisibleForTesting
    public static final Integer NULL_REPOSITORY_ID = -1;
    @VisibleForTesting
    public static final String REPOSITORY_UNIQUENESS = "RepositoryUniqueness";
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryImportService.class);
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final ExternalRepositoryService externalRepositoryService;
    private final I18nService i18nService;
    private final ImporterDao importerDao;
    private final PermissionValidationService permissionValidationService;
    private final RefSyncTaskFactory refSyncTaskFactory;
    private final RepositoryImportTaskHelper repositoryImportTaskHelper;
    private final RepositoryService repositoryService;
    private final ScmService scmService;
    private final SecurityService securityService;
    private final Validator validator;

    public DefaultRepositoryImportService(@Nonnull AuthenticationContext authenticationContext, @Nonnull EventPublisher eventPublisher, @Nonnull ExecutorFactory executorFactory, @Nonnull ExternalRepositoryService externalRepositoryService, @Nonnull ImporterDao importerDao, @Nonnull I18nService i18nService, @Nonnull PermissionValidationService permissionValidationService, @Nonnull RefSyncTaskFactory refSyncTaskFactory, @Nonnull RepositoryImportTaskHelper repositoryImportTaskHelper, @Nonnull RepositoryService repositoryService, @Nonnull ScmService scmService, @Nonnull SecurityService securityService, @Nonnull Validator validator) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.externalRepositoryService = externalRepositoryService;
        this.i18nService = i18nService;
        this.importerDao = importerDao;
        this.permissionValidationService = permissionValidationService;
        this.refSyncTaskFactory = refSyncTaskFactory;
        this.repositoryImportTaskHelper = repositoryImportTaskHelper;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.validator = validator;
        this.executorService = executorFactory.create();
    }

    @Override
    @Nonnull
    public Optional<ImportJob> getImportJob(long jobId, @Nonnull Project project) {
        this.permissionValidationService.validateForProject(Objects.requireNonNull(project, "project"), Permission.REPO_CREATE);
        return this.importerDao.getJob(jobId);
    }

    @Override
    @Nonnull
    public Optional<RepositoryImportTask> getRepositoryImportTask(@Nonnull Repository repository) {
        this.permissionValidationService.validateRepositoryAccessible(Objects.requireNonNull(repository, "repository"));
        return this.importerDao.getImportTask(repository);
    }

    @Override
    @Nonnull
    public ImportJob importRepositories(@Nonnull RepositoriesImportRequest request) {
        Project project = request.getProject();
        this.permissionValidationService.validateForProject(project, Permission.REPO_CREATE);
        this.validateExternalRepositories(request.getExternalRepositories());
        ImportJob importerJob = this.importerDao.createJob(this.authenticationContext.getCurrentUser().getId());
        request.getExternalRepositories().forEach(externalRepository -> {
            Repository repository = this.createRepository((ExternalRepository)externalRepository, importerJob.getJobId(), project);
            if (repository != null) {
                RepositoryImportTask importTask = this.repositoryImportTaskHelper.createImportTask(importerJob.getJobId(), externalRepository.getCloneUrl(), externalRepository.getName(), repository.getId(), ImportTaskState.QUEUED);
                this.executorService.submit(this.refSyncTaskFactory.create(externalRepository.getCloneUrl(), request.getCredential().orElse(null), importTask.getTaskId(), repository));
            }
        });
        ImportJob updatedJob = this.importerDao.getJob(importerJob.getJobId()).orElseThrow(() -> new IllegalStateException("The import job with id " + importerJob.getJobId() + " cannot be found, even though it was just created"));
        this.eventPublisher.publish((Object)new ImportJobCreatedEvent(this, updatedJob.getJobId(), project.getId(), updatedJob.getTasks().size()));
        return updatedJob;
    }

    @Override
    @Nonnull
    public ImportJob importRepositoriesForOwner(@Nonnull OwnerImportRequest request) {
        Credential credential = request.getCredential();
        Project project = request.getProject();
        this.permissionValidationService.validateForProject(project, Permission.REPO_CREATE);
        ExternalRepositorySearchRequest repoSearchRequest = new ExternalRepositorySearchRequest.Builder(credential, request.getSource()).ownerName(request.getOwner().map(ExternalOwner::getName).orElse(null)).build();
        List<ExternalRepository> repositories = MoreStreams.streamIterable((Iterable)new PagedIterable(pageRequest -> this.externalRepositoryService.searchRepositories(repoSearchRequest, pageRequest), 100)).collect(Collectors.toList());
        RepositoriesImportRequest importRequest = new RepositoriesImportRequest.Builder(project).credential(credential).externalRepositories(repositories).build();
        return this.importRepositories(importRequest);
    }

    public void onStart() {
        this.cleanUpUnfinishedRepositoryImports();
    }

    public void onStop() {
        ExecutorUtils.shutdown((ExecutorService)this.executorService, (Logger)log);
    }

    private void cleanUpUnfinishedRepositoryImports() {
        this.securityService.withPermission(Permission.SYS_ADMIN, "Deleting repositories after unfinished repository imports").call(() -> {
            this.importerDao.getUnfinishedTasks().forEach(unfinishedTask -> {
                unfinishedTask.getRepository().ifPresent(repository -> {
                    log.warn("{}: Deleting after unfinished import", repository);
                    this.repositoryService.delete(repository);
                });
                this.repositoryImportTaskHelper.failImportTask(unfinishedTask.getTaskId(), ImportTaskFailureType.SYNC_INCOMPLETE);
            });
            return null;
        });
    }

    @Nullable
    private Repository createRepository(ExternalRepository externalRepository, long jobId, Project project) {
        try {
            return this.repositoryService.create(((RepositoryCreateRequest.Builder)new RepositoryCreateRequest.Builder().name(externalRepository.getName())).project(project).scmId(externalRepository.getScmId()).build());
        }
        catch (ConstraintViolationException e) {
            ImportTaskFailureType failureType = ImportTaskFailureType.CREATE_CONSTRAINT;
            if (e.getConstraintViolations().stream().anyMatch(constraintViolation -> constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName().equals(REPOSITORY_UNIQUENESS))) {
                failureType = ImportTaskFailureType.CREATE_CONSTRAINT_UNIQUE_REPOSITORY;
            }
            log.info("Failed to import repository {} due to the following constraint violations: {}", (Object)externalRepository.getName(), (Object)e.getConstraintViolations().stream().map(violation -> "\"" + violation.getMessage() + "\"").collect(Collectors.joining(", ", "[", "]")));
            this.repositoryImportTaskHelper.createFailedImportTask(jobId, externalRepository.getCloneUrl(), externalRepository.getName(), NULL_REPOSITORY_ID, failureType);
        }
        catch (ServiceException e) {
            log.error("Failed to import repository: {}", (Object)externalRepository.getName(), (Object)e);
            this.repositoryImportTaskHelper.createFailedImportTask(jobId, externalRepository.getCloneUrl(), externalRepository.getName(), NULL_REPOSITORY_ID, ImportTaskFailureType.CREATE_FAILED);
        }
        return null;
    }

    private void validateExternalRepositories(List<ExternalRepository> externalRepositories) {
        Set constraintViolations = externalRepositories.stream().map(repo -> this.validator.validate(repo, new Class[0])).flatMap(Collection::stream).collect(Collectors.toSet());
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        Set supportedScmIds = this.scmService.getAvailable().stream().map(AvailableScm::getId).filter(scmId -> this.scmService.isSupported(scmId, ScmFeature.MIRRORS)).collect(Collectors.toSet());
        List unsupportedRepositories = externalRepositories.stream().filter(repo -> !supportedScmIds.contains(repo.getScmId())).map(ExternalRepository::getName).collect(Collectors.toList());
        if (!unsupportedRepositories.isEmpty()) {
            throw new UnsupportedScmForImportException(this.i18nService.createKeyedMessage("bitbucket.importer.unsupported.scm", new Object[]{unsupportedRepositories, supportedScmIds, supportedScmIds.size()}));
        }
    }
}

