/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.repository;

import com.atlassian.bitbucket.internal.importer.dao.AoImportJob;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTask;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ImportJob {
    private final Date createdDate;
    private final long jobId;
    private final List<RepositoryImportTask> tasks;

    private ImportJob(Builder builder) {
        this.createdDate = builder.createdDate;
        this.jobId = builder.jobId;
        this.tasks = builder.tasks.build();
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public long getJobId() {
        return this.jobId;
    }

    @Nonnull
    public List<RepositoryImportTask> getTasks() {
        return this.tasks;
    }

    public static class Builder {
        private Date createdDate;
        private long jobId;
        private ImmutableList.Builder<RepositoryImportTask> tasks = ImmutableList.builder();

        public Builder() {
        }

        public Builder(@Nonnull AoImportJob aoImportJob) {
            this.createdDate = aoImportJob.getCreatedDate();
            this.jobId = aoImportJob.getId();
        }

        @Nonnull
        public ImportJob build() {
            return new ImportJob(this);
        }

        @Nonnull
        public Builder createdDate(Date value) {
            this.createdDate = value;
            return this;
        }

        @Nonnull
        public Builder jobId(long value) {
            this.jobId = value;
            return this;
        }

        @Nonnull
        public Builder tasks(@Nonnull List<RepositoryImportTask> value) {
            this.tasks.addAll((Iterable)Objects.requireNonNull(value, "tasks"));
            return this;
        }

        @Nonnull
        public Builder task(@Nonnull RepositoryImportTask value) {
            this.tasks.add((Object)value);
            return this;
        }
    }
}

