/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.repository;

import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalOwner;
import com.atlassian.bitbucket.internal.importer.ExternalRequest;
import com.atlassian.bitbucket.internal.importer.ExternalSource;
import com.atlassian.bitbucket.project.Project;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class OwnerImportRequest
extends ExternalRequest {
    private Optional<ExternalOwner> owner;
    private Project project;

    private OwnerImportRequest(@Nonnull Builder builder) {
        super(builder);
        this.owner = builder.owner;
        this.project = builder.project;
    }

    @Nonnull
    public Optional<ExternalOwner> getOwner() {
        return this.owner;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    public static class Builder
    extends ExternalRequest.Builder {
        private Optional<ExternalOwner> owner = Optional.empty();
        private final Project project;

        public Builder(@Nonnull Credential credential, @Nonnull Project project, @Nonnull ExternalSource source) {
            super(credential, source);
            this.project = Objects.requireNonNull(project, "project");
        }

        @Override
        @Nonnull
        public OwnerImportRequest build() {
            return new OwnerImportRequest(this);
        }

        @Nonnull
        public Builder owner(@Nullable ExternalOwner value) {
            this.owner = Optional.ofNullable(value);
            return this;
        }
    }
}

