/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.repository;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskFailureType;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskState;
import com.atlassian.bitbucket.internal.importer.repository.RefSyncTaskParameters;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTaskHelper;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.AuthenticationFailedScmException;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.NotAuthorizedScmException;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCallback;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCommandParameters;
import com.atlassian.bitbucket.scm.mirror.ScmMirrorCommandFactory;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefSyncTask
implements Callable<Void> {
    private static final Logger log = LoggerFactory.getLogger(RefSyncTask.class);
    private final EventPublisher eventPublisher;
    private final RefSyncTaskParameters parameters;
    private final RepositoryImportTaskHelper repositoryImportTaskHelper;
    private final RepositoryService repositoryService;
    private final ScmService scmService;
    private final SecurityService securityService;

    public RefSyncTask(EventPublisher eventPublisher, RepositoryImportTaskHelper repositoryImportTaskHelper, RepositoryService repositoryService, ScmService scmService, SecurityService securityService, RefSyncTaskParameters parameters) {
        this.eventPublisher = eventPublisher;
        this.repositoryImportTaskHelper = repositoryImportTaskHelper;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.parameters = parameters;
    }

    @Override
    public Void call() {
        this.securityService.impersonating(this.parameters.getUser(), "Importing repository").call(this::importRepository);
        return null;
    }

    private MirrorSyncCommandParameters buildSyncParameters(String cloneUrl) {
        MirrorSyncCommandParameters.Builder syncParameters = new MirrorSyncCommandParameters.Builder(cloneUrl).atomic(true);
        if (this.parameters.getCredential().isPresent()) {
            syncParameters.username(this.parameters.getCredential().get().getUsername());
            syncParameters.password(this.parameters.getCredential().get().getPassword());
        } else {
            syncParameters.anonymous(true);
        }
        return syncParameters.build();
    }

    private void handleError(Repository repository, Long taskId, ImportTaskFailureType failureType, Exception e) {
        log.error("Failed to import repository: {}", (Object)repository, (Object)e);
        if (this.repositoryService.getById(repository.getId()) != null) {
            this.securityService.withPermission(Permission.SYS_ADMIN, "Deleting a failed repository import").call(() -> {
                this.repositoryService.delete(repository);
                return null;
            });
        }
        this.repositoryImportTaskHelper.failImportTask(taskId, failureType);
    }

    private Object importRepository() {
        String cloneUrl = this.parameters.getCloneUrl();
        Repository repository = this.parameters.getRepository();
        Long taskId = this.parameters.getTaskId();
        this.repositoryImportTaskHelper.updateImportTask(taskId, ImportTaskState.STARTED);
        ScmMirrorCommandFactory commandFactory = this.scmService.getMirrorCommandFactory(repository);
        MirrorSyncCommandParameters syncParameters = this.buildSyncParameters(cloneUrl);
        ImporterSyncCallback syncCallback = new ImporterSyncCallback();
        try (Timer ignored = TimerUtils.start((String)("[" + String.valueOf(repository) + "] fetch from " + cloneUrl));){
            this.syncRefs(commandFactory, syncParameters, syncCallback);
            this.eventPublisher.publish((Object)new RepositoryImportedEvent(this, repository, syncCallback.getChanges(), syncCallback.getFailedRefs(), cloneUrl));
            this.repositoryImportTaskHelper.updateImportTask(taskId, ImportTaskState.SUCCESS);
        }
        catch (AuthenticationFailedScmException e) {
            this.handleError(repository, taskId, ImportTaskFailureType.AUTHENTICATION_FAILED, (Exception)((Object)e));
        }
        catch (NotAuthorizedScmException e) {
            this.handleError(repository, taskId, ImportTaskFailureType.UNAUTHORIZED, (Exception)((Object)e));
        }
        catch (ServiceException e) {
            this.handleError(repository, taskId, ImportTaskFailureType.SYNC_FAILED, (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.handleError(repository, taskId, ImportTaskFailureType.NONE, e);
        }
        return null;
    }

    private void syncRefs(ScmMirrorCommandFactory commandFactory, MirrorSyncCommandParameters syncParameters, ImporterSyncCallback syncCallback) {
        Command command = commandFactory.synchronize(syncParameters, (MirrorSyncCallback)syncCallback);
        command.setIdleTimeout(this.parameters.getIdleTimeout(TimeUnit.SECONDS));
        command.setExecutionTimeout(this.parameters.getExecutionTimeout(TimeUnit.SECONDS));
        command.call();
    }

    private static class ImporterSyncCallback
    implements MirrorSyncCallback {
        private final ImmutableList.Builder<RefChange> changes = ImmutableList.builder();
        private final ImmutableList.Builder<MinimalRef> failedRefs = ImmutableList.builder();

        private ImporterSyncCallback() {
        }

        public List<RefChange> getChanges() {
            return this.changes.build();
        }

        public List<MinimalRef> getFailedRefs() {
            return this.failedRefs.build();
        }

        public boolean onFailedRef(@Nonnull MinimalRef ref) {
            this.failedRefs.add((Object)ref);
            return true;
        }

        public boolean onRefChange(@Nonnull RefChange refChange) {
            this.changes.add((Object)refChange);
            return true;
        }
    }
}

