/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.repository;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ImporterConstants;
import com.atlassian.bitbucket.internal.importer.repository.RefSyncTask;
import com.atlassian.bitbucket.internal.importer.repository.RefSyncTaskParameters;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTaskHelper;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class RefSyncTaskFactory {
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final RepositoryService repositoryService;
    private final RepositoryImportTaskHelper repositoryImportTaskHelper;
    private final ScmService scmService;
    private final SecurityService securityService;
    private final Long idleTimeoutMinutes;
    private final Long executionTimeoutMinutes;

    public RefSyncTaskFactory(AuthenticationContext authenticationContext, EventPublisher eventPublisher, ApplicationPropertiesService propertiesService, RepositoryImportTaskHelper repositoryImportTaskHelper, RepositoryService repositoryService, ScmService scmService, SecurityService securityService) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.repositoryImportTaskHelper = repositoryImportTaskHelper;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.idleTimeoutMinutes = propertiesService.getPluginProperty("plugin.importer.repository.fetch.timeout.idle", ImporterConstants.PROPERTY_REPO_FETCH_TIMEOUT_IDLE_DEFAULT);
        this.executionTimeoutMinutes = propertiesService.getPluginProperty("plugin.importer.repository.fetch.timeout.execution", ImporterConstants.PROPERTY_REPO_FETCH_TIMEOUT_EXEC_DEFAULT);
    }

    @Nonnull
    public RefSyncTask create(@Nonnull String cloneUrl, @Nullable Credential credential, long taskId, @Nonnull Repository repository) {
        RefSyncTaskParameters parameters = new RefSyncTaskParameters.Builder().cloneUrl(Objects.requireNonNull(cloneUrl, "cloneUrl")).credential(credential).executionTimeout(this.executionTimeoutMinutes, TimeUnit.MINUTES).idleTimeout(this.idleTimeoutMinutes, TimeUnit.MINUTES).repository(Objects.requireNonNull(repository, "repository")).taskId(taskId).user(this.authenticationContext.getCurrentUser()).build();
        return new RefSyncTask(this.eventPublisher, this.repositoryImportTaskHelper, this.repositoryService, this.scmService, this.securityService, parameters);
    }
}

