/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.repository;

import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class RefSyncTaskParameters {
    private final String cloneUrl;
    private final Credential credential;
    private final long executionTimeoutSec;
    private final long idleTimeoutSec;
    private final Repository repository;
    private final Long taskId;
    private final ApplicationUser user;

    private RefSyncTaskParameters(Builder builder) {
        this.cloneUrl = builder.cloneUrl;
        this.credential = builder.credential;
        this.executionTimeoutSec = builder.executionTimeoutSec;
        this.idleTimeoutSec = builder.idleTimeoutSec;
        this.repository = builder.repository;
        this.taskId = builder.taskId;
        this.user = builder.user;
    }

    @Nonnull
    public String getCloneUrl() {
        return this.cloneUrl;
    }

    @Nonnull
    public Optional<Credential> getCredential() {
        return Optional.ofNullable(this.credential);
    }

    public long getExecutionTimeout(@Nonnull TimeUnit timeUnit) {
        return Objects.requireNonNull(timeUnit, "timeUnit").convert(this.executionTimeoutSec, TimeUnit.SECONDS);
    }

    public long getIdleTimeout(@Nonnull TimeUnit timeUnit) {
        return Objects.requireNonNull(timeUnit, "timeUnit").convert(this.idleTimeoutSec, TimeUnit.SECONDS);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public Long getTaskId() {
        return this.taskId;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public static class Builder {
        private String cloneUrl;
        private Credential credential;
        private long executionTimeoutSec;
        private long idleTimeoutSec;
        private Repository repository;
        private Long taskId;
        private ApplicationUser user;

        @Nonnull
        public RefSyncTaskParameters build() {
            Objects.requireNonNull(this.cloneUrl, "cloneUrl");
            Objects.requireNonNull(this.repository, "repository");
            Objects.requireNonNull(this.taskId, "taskId");
            Objects.requireNonNull(this.user, "user");
            return new RefSyncTaskParameters(this);
        }

        @Nonnull
        public Builder cloneUrl(@Nonnull String value) {
            this.cloneUrl = Objects.requireNonNull(value, "cloneUrl");
            return this;
        }

        @Nonnull
        public Builder credential(@Nullable Credential value) {
            this.credential = value;
            return this;
        }

        @Nonnull
        public Builder executionTimeout(long value, @Nonnull TimeUnit timeUnit) {
            this.executionTimeoutSec = timeUnit.toSeconds(value);
            return this;
        }

        @Nonnull
        public Builder idleTimeout(long value, @Nonnull TimeUnit timeUnit) {
            this.idleTimeoutSec = timeUnit.toSeconds(value);
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull Repository value) {
            this.repository = Objects.requireNonNull(value, "repository");
            return this;
        }

        @Nonnull
        public Builder taskId(@Nonnull Long value) {
            this.taskId = Objects.requireNonNull(value, "taskId");
            return this;
        }

        @Nonnull
        public Builder user(@Nonnull ApplicationUser value) {
            this.user = Objects.requireNonNull(value, "user");
            return this;
        }
    }
}

