/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.repository;

import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalRepository;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RepositoriesImportRequest {
    private final Credential credential;
    private final List<ExternalRepository> externalRepositories;
    private final Project project;

    private RepositoriesImportRequest(Builder builder) {
        this.credential = builder.credential;
        this.externalRepositories = builder.externalRepositoriesBuilder.build();
        this.project = builder.project;
    }

    @Nonnull
    public Optional<Credential> getCredential() {
        return Optional.ofNullable(this.credential);
    }

    @Nonnull
    public List<ExternalRepository> getExternalRepositories() {
        return this.externalRepositories;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<ExternalRepository> externalRepositoriesBuilder = ImmutableList.builder();
        private final Project project;
        private Credential credential;

        public Builder(@Nonnull Project project) {
            this.project = Objects.requireNonNull(project, "project");
        }

        @Nonnull
        public RepositoriesImportRequest build() {
            return new RepositoriesImportRequest(this);
        }

        @Nonnull
        public Builder credential(@Nullable Credential value) {
            this.credential = value;
            return this;
        }

        @Nonnull
        public Builder externalRepositories(@Nonnull List<ExternalRepository> repositories) {
            Builder.addIf(Objects::nonNull, this.externalRepositoriesBuilder, (Iterable)Objects.requireNonNull(repositories, "repositories"));
            return this;
        }

        @Nonnull
        public Builder externalRepository(@Nonnull ExternalRepository repository) {
            this.externalRepositoriesBuilder.add((Object)Objects.requireNonNull(repository, "externalRepository"));
            return this;
        }
    }
}

