/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.repository;

import com.atlassian.bitbucket.internal.importer.dao.AoRepositoryImportTask;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskFailureType;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskState;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class RepositoryImportTask {
    private final String cloneUrl;
    private final Date created;
    private final String externalRepoName;
    private final ImportTaskFailureType failureType;
    private final long jobId;
    private final Date lastUpdated;
    private final Repository repository;
    private final ImportTaskState state;
    private final Long taskId;

    private RepositoryImportTask(Builder builder) {
        this.cloneUrl = builder.cloneUrl;
        this.created = builder.created;
        this.externalRepoName = builder.externalRepoName;
        this.failureType = builder.failureType;
        this.jobId = builder.jobId;
        this.lastUpdated = builder.lastUpdated;
        this.repository = builder.repository;
        this.state = builder.state;
        this.taskId = builder.taskId;
    }

    @Nonnull
    public String getCloneUrl() {
        return this.cloneUrl;
    }

    @Nonnull
    public Date getCreated() {
        return this.created;
    }

    @Nonnull
    public String getExternalRepoName() {
        return this.externalRepoName;
    }

    @Nonnull
    public ImportTaskFailureType getFailureType() {
        return this.failureType;
    }

    public long getJobId() {
        return this.jobId;
    }

    @Nonnull
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Nonnull
    public Optional<Repository> getRepository() {
        return Optional.ofNullable(this.repository);
    }

    @Nonnull
    public ImportTaskState getState() {
        return this.state;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public static class Builder {
        private String cloneUrl;
        private Date created;
        private String externalRepoName;
        private ImportTaskFailureType failureType;
        private long jobId;
        private Date lastUpdated;
        private Repository repository;
        private ImportTaskState state = ImportTaskState.QUEUED;
        private Long taskId;

        public Builder() {
        }

        public Builder(Repository repository, AoRepositoryImportTask aoTask) {
            this.repository = repository;
            this.cloneUrl = aoTask.getCloneUrl();
            this.created = aoTask.getCreated();
            this.externalRepoName = aoTask.getExternalRepoName();
            this.failureType = aoTask.getFailureType();
            this.jobId = aoTask.getImportJobId();
            this.lastUpdated = aoTask.getLastUpdated();
            this.state = aoTask.getState();
            this.taskId = aoTask.getId();
        }

        @Nonnull
        public RepositoryImportTask build() {
            Objects.requireNonNull(this.cloneUrl, "cloneUrl");
            Objects.requireNonNull(this.created, "created");
            Objects.requireNonNull(this.externalRepoName, "externalRepoName");
            Objects.requireNonNull(this.lastUpdated, "lastUpdated");
            return new RepositoryImportTask(this);
        }

        @Nonnull
        public Builder cloneUrl(@Nonnull String value) {
            this.cloneUrl = Objects.requireNonNull(value, "cloneUrl");
            return this;
        }

        @Nonnull
        public Builder created(@Nonnull Date value) {
            this.created = Objects.requireNonNull(value, "created");
            return this;
        }

        @Nonnull
        public Builder externalRepoName(@Nonnull String value) {
            this.externalRepoName = Objects.requireNonNull(value, "externalRepoName");
            return this;
        }

        @Nonnull
        public Builder failureType(@Nonnull ImportTaskFailureType value) {
            this.failureType = Objects.requireNonNull(value, "failureType");
            return this;
        }

        @Nonnull
        public Builder jobId(long value) {
            this.jobId = value;
            return this;
        }

        @Nonnull
        public Builder lastUpdated(@Nonnull Date value) {
            this.lastUpdated = Objects.requireNonNull(value, "lastUpdated");
            return this;
        }

        @Nonnull
        public Builder repository(@Nullable Repository value) {
            this.repository = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull ImportTaskState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }

        @Nonnull
        public Builder taskId(long value) {
            this.taskId = value;
            return this;
        }
    }
}

