/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.repository;

import com.atlassian.bitbucket.internal.importer.dao.ImporterDao;
import com.atlassian.bitbucket.internal.importer.event.RepositoryImportTaskStateChangedEvent;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskFailureType;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskState;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTask;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;

public class RepositoryImportTaskHelper {
    private final EventPublisher eventPublisher;
    private final ImporterDao importerDao;

    public RepositoryImportTaskHelper(@Nonnull EventPublisher eventPublisher, @Nonnull ImporterDao importerDao) {
        this.eventPublisher = eventPublisher;
        this.importerDao = importerDao;
    }

    public void failImportTask(long taskId, @Nonnull ImportTaskFailureType failureType) {
        RepositoryImportTask importTaskStarted = this.importerDao.updateImportTaskState(taskId, ImportTaskState.FAILED, failureType);
        this.publishEvent(importTaskStarted);
    }

    public void updateImportTask(long taskId, @Nonnull ImportTaskState state) {
        if (state == ImportTaskState.FAILED) {
            throw new IllegalArgumentException("To update a FAILED task, or set a task to FAILED, call failImportTask instead");
        }
        RepositoryImportTask importTaskStarted = this.importerDao.updateImportTaskState(taskId, state, ImportTaskFailureType.NONE);
        this.publishEvent(importTaskStarted);
    }

    public RepositoryImportTask createFailedImportTask(long jobId, @Nonnull String cloneUrl, @Nonnull String externalRepoName, int repositoryId, @Nonnull ImportTaskFailureType failureType) {
        return this.createImportTask(jobId, cloneUrl, externalRepoName, repositoryId, ImportTaskState.FAILED, failureType);
    }

    public RepositoryImportTask createImportTask(long jobId, @Nonnull String cloneUrl, @Nonnull String externalRepoName, int repositoryId, @Nonnull ImportTaskState state) {
        if (state == ImportTaskState.FAILED) {
            throw new IllegalArgumentException("To create a FAILED task, call createFailedTask instead");
        }
        return this.createImportTask(jobId, cloneUrl, externalRepoName, repositoryId, state, ImportTaskFailureType.NONE);
    }

    private RepositoryImportTask createImportTask(long jobId, @Nonnull String cloneUrl, @Nonnull String externalRepoName, int repositoryId, @Nonnull ImportTaskState state, @Nonnull ImportTaskFailureType failureType) {
        RepositoryImportTask importTask = this.importerDao.createImportTask(jobId, cloneUrl, externalRepoName, failureType, repositoryId, state);
        this.publishEvent(importTask);
        return importTask;
    }

    private void publishEvent(RepositoryImportTask repositoryImportTask) {
        this.eventPublisher.publish((Object)new RepositoryImportTaskStateChangedEvent(this, repositoryImportTask.getState(), repositoryImportTask.getFailureType(), repositoryImportTask.getJobId(), repositoryImportTask.getRepository().map(Repository::getId).orElse(-1), repositoryImportTask.getTaskId()));
    }
}

