/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.importer.DelegatingRepositoryService;
import com.atlassian.bitbucket.internal.importer.ExternalOwner;
import com.atlassian.bitbucket.internal.importer.ExternalOwnerSearchRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRepository;
import com.atlassian.bitbucket.internal.importer.ExternalRepositorySearchRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRequest;
import com.atlassian.bitbucket.internal.importer.ExternalRequestAuthenticationFailedException;
import com.atlassian.bitbucket.internal.importer.ExternalRequestFailedException;
import com.atlassian.bitbucket.internal.importer.ExternalRequestForbiddenException;
import com.atlassian.bitbucket.internal.importer.ExternalUser;
import com.atlassian.bitbucket.internal.importer.OAuthScope;
import com.atlassian.bitbucket.internal.importer.UnsupportedSourceException;
import com.atlassian.bitbucket.internal.importer.rest.ResourceHelper;
import com.atlassian.bitbucket.internal.importer.rest.ResponseError;
import com.atlassian.bitbucket.internal.importer.rest.RestExternalOwner;
import com.atlassian.bitbucket.internal.importer.rest.RestExternalOwnerSearchRequest;
import com.atlassian.bitbucket.internal.importer.rest.RestExternalRepository;
import com.atlassian.bitbucket.internal.importer.rest.RestExternalRepositorySearchRequest;
import com.atlassian.bitbucket.internal.importer.rest.RestExternalRequest;
import com.atlassian.bitbucket.internal.importer.rest.RestExternalUser;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/external-source")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@LicensedOnly
public class ExternalRepositoryResource {
    private static final Logger log = LoggerFactory.getLogger(ExternalRepositoryResource.class);
    private final DelegatingRepositoryService externalRepositoryService;
    private final ResourceHelper resourceHelper;

    @Inject
    public ExternalRepositoryResource(DelegatingRepositoryService externalRepositoryService, ResourceHelper resourceHelper) {
        this.externalRepositoryService = externalRepositoryService;
        this.resourceHelper = resourceHelper;
    }

    @Path(value="/missing-oauth-scopes")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMissingOAuthScopes(RestExternalRequest request) {
        List<RestErrorMessage> errors = this.resourceHelper.validate(request);
        if (!errors.isEmpty()) {
            return this.resourceHelper.restRequestError(errors);
        }
        ExternalRequest userRequest = new ExternalRequest.Builder(this.resourceHelper.credential(request), this.resourceHelper.source(request)).build();
        return this.executeRequest(() -> {
            Set<OAuthScope> missingOAuthScopes = this.externalRepositoryService.getMissingOAuthScopes(userRequest);
            return ResponseFactory.ok(missingOAuthScopes).build();
        });
    }

    @Path(value="/user")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUser(RestExternalRequest request) {
        List<RestErrorMessage> errors = this.resourceHelper.validate(request);
        if (!errors.isEmpty()) {
            return this.resourceHelper.restRequestError(errors);
        }
        ExternalRequest userRequest = new ExternalRequest.Builder(this.resourceHelper.credential(request), this.resourceHelper.source(request)).build();
        return this.executeRequest(() -> {
            ExternalUser user = this.externalRepositoryService.getUser(userRequest);
            return ResponseFactory.ok((Object)new RestExternalUser(user)).build();
        });
    }

    @Path(value="/owners")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchOwners(RestExternalOwnerSearchRequest request, @BeanParam PageRequestResolver pageRequestResolver) {
        List<RestErrorMessage> errors = this.resourceHelper.validate(request);
        if (!errors.isEmpty()) {
            return this.resourceHelper.restRequestError(errors);
        }
        ExternalOwnerSearchRequest searchRequest = new ExternalOwnerSearchRequest.Builder(this.resourceHelper.credential(request), this.resourceHelper.source(request)).build();
        return this.executeRequest(() -> {
            Page<ExternalOwner> owners = this.externalRepositoryService.searchOwners(searchRequest, pageRequestResolver.getPageRequest());
            return ResponseFactory.ok((Object)new RestPage(owners, owner -> new RestExternalOwner((ExternalOwner)owner))).build();
        });
    }

    @Path(value="/repos")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchRepositories(RestExternalRepositorySearchRequest request, @BeanParam PageRequestResolver pageRequestResolver) {
        List<RestErrorMessage> errors = this.resourceHelper.validate(request);
        if (!errors.isEmpty()) {
            return this.resourceHelper.restRequestError(errors);
        }
        ExternalRepositorySearchRequest builder = new ExternalRepositorySearchRequest.Builder(this.resourceHelper.credential(request), this.resourceHelper.source(request)).filter(request.getFilter()).ownerName(request.getOwnerName()).build();
        return this.executeRequest(() -> {
            Page<ExternalRepository> repositories = this.externalRepositoryService.searchRepositories(builder, pageRequestResolver.getPageRequest());
            return ResponseFactory.ok((Object)new RestPage(repositories, RestExternalRepository::new)).build();
        });
    }

    private Response executeRequest(Supplier<Response> supplier) {
        try {
            return supplier.get();
        }
        catch (ExternalRequestAuthenticationFailedException e) {
            return this.externalRequestError(ResponseError.AUTHENTICATION, (Exception)((Object)e));
        }
        catch (ExternalRequestForbiddenException e) {
            return this.externalRequestError(ResponseError.FORBIDDEN, (Exception)((Object)e));
        }
        catch (ExternalRequestFailedException e) {
            return this.externalRequestError(ResponseError.EXTERNAL_REQUEST, (Exception)((Object)e));
        }
        catch (UnsupportedSourceException e) {
            return this.externalRequestError(ResponseError.UNSUPPORTED_SOURCE, (Exception)((Object)e));
        }
    }

    private Response externalRequestError(ResponseError context, Exception e) {
        log.warn("Error making external request: {}", (Object)e.getMessage());
        return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(new RestErrorMessage(context.name(), "Error accessing remote repository"))).build();
    }
}

