/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalRepository;
import com.atlassian.bitbucket.internal.importer.ExternalSource;
import com.atlassian.bitbucket.internal.importer.repository.OwnerImportRequest;
import com.atlassian.bitbucket.internal.importer.repository.RepositoriesImportRequest;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportService;
import com.atlassian.bitbucket.internal.importer.rest.ResourceHelper;
import com.atlassian.bitbucket.internal.importer.rest.RestCredential;
import com.atlassian.bitbucket.internal.importer.rest.RestExternalOwner;
import com.atlassian.bitbucket.internal.importer.rest.RestImportJob;
import com.atlassian.bitbucket.internal.importer.rest.RestOwnerImportRequest;
import com.atlassian.bitbucket.internal.importer.rest.RestRepositoriesImportRequest;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="projects/{projectKey}/import")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@LicensedOnly
public class RepositoryImportResource {
    private final I18nService i18nService;
    private final RepositoryImportService repositoryImportService;
    private final ResourceHelper resourceHelper;
    private final Validator validator;

    @Inject
    public RepositoryImportResource(I18nService i18nService, RepositoryImportService repositoryImportService, ResourceHelper resourceHelper, Validator validator) {
        this.i18nService = i18nService;
        this.repositoryImportService = repositoryImportService;
        this.resourceHelper = resourceHelper;
        this.validator = validator;
    }

    @Path(value="/job/{jobId}")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getImportJob(@BeanParam ProjectResolver projectResolver, @PathParam(value="jobId") long jobId) {
        return this.repositoryImportService.getImportJob(jobId, projectResolver.getProject()).map(RestImportJob::new).map(importJob -> ResponseFactory.ok((Object)importJob).build()).orElse(ResponseFactory.notFound().build());
    }

    @Path(value="/owner-repos")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response importAllRepositoriesForOwner(@BeanParam ProjectResolver projectResolver, RestOwnerImportRequest request) {
        List<RestErrorMessage> errors = this.resourceHelper.validate(request);
        if (!errors.isEmpty()) {
            return this.resourceHelper.restRequestError(errors);
        }
        RestExternalOwner owner = request.getOwner();
        if (owner != null) {
            ValidationUtils.validate((Validator)this.validator, (Object)owner, (Class[])new Class[0]);
        }
        Credential credential = this.resourceHelper.credential(request);
        ExternalSource source = this.resourceHelper.source(request);
        OwnerImportRequest importRequest = new OwnerImportRequest.Builder(credential, projectResolver.getProject(), source).owner(owner).build();
        return Response.ok((Object)((Object)new RestImportJob(this.repositoryImportService.importRepositoriesForOwner(importRequest)))).build();
    }

    @Path(value="/repos")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response importRepositories(@BeanParam ProjectResolver projectResolver, RestRepositoriesImportRequest request) {
        List<ExternalRepository> externalRepositories = request.getExternalRepositories();
        if (externalRepositories.isEmpty()) {
            return ResponseFactory.error((Response.Status)Response.Status.BAD_REQUEST, (String)"externalRepositories", (String)this.i18nService.getMessage("bitbucket.importer.rest.import.repository.empty.externalrepositories", new Object[0])).build();
        }
        RepositoriesImportRequest.Builder importRequestBuilder = new RepositoriesImportRequest.Builder(projectResolver.getProject()).externalRepositories(externalRepositories);
        RestCredential restCredential = request.getCredential();
        if (restCredential != null) {
            List<RestErrorMessage> errors = this.resourceHelper.validateCredential(restCredential);
            if (!errors.isEmpty()) {
                return this.resourceHelper.restRequestError(errors);
            }
            importRequestBuilder.credential(new Credential.Builder(restCredential.getUsername(), restCredential.getPassword()).build());
        }
        RestImportJob importJob = new RestImportJob(this.repositoryImportService.importRepositories(importRequestBuilder.build()));
        return Response.ok((Object)((Object)importJob)).build();
    }
}

