/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.rest;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.importer.Credential;
import com.atlassian.bitbucket.internal.importer.ExternalSource;
import com.atlassian.bitbucket.internal.importer.SourceType;
import com.atlassian.bitbucket.internal.importer.rest.ResponseError;
import com.atlassian.bitbucket.internal.importer.rest.RestCredential;
import com.atlassian.bitbucket.internal.importer.rest.RestExternalRequest;
import com.atlassian.bitbucket.internal.importer.rest.RestExternalSource;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.google.common.collect.ImmutableList;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ResourceHelper {
    private final I18nService i18nService;

    public ResourceHelper(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public Credential credential(RestExternalRequest request) {
        RestCredential restCredential = request.getCredential();
        return new Credential.Builder(restCredential.getUsername(), restCredential.getPassword()).build();
    }

    public Response restRequestError(List<RestErrorMessage> errors) {
        RestErrors restErrors = new RestErrors.Builder().addErrorMessages(errors).build();
        return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)restErrors).build();
    }

    public ExternalSource source(RestExternalRequest request) {
        RestExternalSource source = request.getSource();
        return new ExternalSource.Builder(source.getType()).url(source.getUrl()).build();
    }

    public List<RestErrorMessage> validate(RestExternalRequest request) {
        ImmutableList.Builder errors = ImmutableList.builder();
        RestCredential credential = request.getCredential();
        if (credential == null) {
            errors.add((Object)new RestErrorMessage(ResponseError.INVALID_CREDENTIALS.name(), this.i18nService.getMessage("bitbucket.importer.rest.external.repository.search.empty.credentials", new Object[0])));
        } else {
            errors.addAll(this.validateCredential(credential));
        }
        RestExternalSource source = request.getSource();
        if (source == null) {
            errors.add((Object)new RestErrorMessage(ResponseError.INVALID_SOURCE.name(), this.i18nService.getMessage("bitbucket.importer.rest.external.repository.search.empty.sourcetype", new Object[0])));
        } else if (source.getType() == null) {
            errors.add((Object)new RestErrorMessage(ResponseError.INVALID_SOURCE.name(), this.i18nService.getMessage("bitbucket.importer.rest.external.repository.search.empty.sourcetype", new Object[0])));
        } else if (source.getType() == SourceType.GITHUB && !StringUtils.isBlank((CharSequence)source.getUrl()) && !StringUtils.startsWithIgnoreCase((CharSequence)source.getUrl(), (CharSequence)"https")) {
            errors.add((Object)new RestErrorMessage(ResponseError.INVALID_SOURCE.name(), this.i18nService.getMessage("bitbucket.importer.rest.external.repository.ghe.url.http", new Object[0])));
        }
        return errors.build();
    }

    public List<RestErrorMessage> validateCredential(RestCredential credential) {
        ImmutableList.Builder errors = ImmutableList.builder();
        if (StringUtils.isBlank((CharSequence)credential.getUsername())) {
            errors.add((Object)new RestErrorMessage(ResponseError.INVALID_CREDENTIALS.name(), this.i18nService.getMessage("bitbucket.importer.rest.external.repository.search.empty.username", new Object[0])));
        }
        if (StringUtils.isBlank((CharSequence)credential.getPassword())) {
            errors.add((Object)new RestErrorMessage(ResponseError.INVALID_CREDENTIALS.name(), this.i18nService.getMessage("bitbucket.importer.rest.external.repository.search.empty.password", new Object[0])));
        }
        return errors.build();
    }
}

