/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.rest;

import com.atlassian.bitbucket.internal.importer.ExternalRepository;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.Map;

@JsonSerialize
@JsonSurrogate(value=ExternalRepository.class)
public class RestExternalRepository
extends RestMapEntity
implements ExternalRepository {
    public static final String CLONE_URL = "cloneUrl";
    public static final String DESCRIPTION = "description";
    public static final String NAME = "name";
    public static final String SCM_ID = "scmId";

    public RestExternalRepository(Map map) {
        this.putAll(map);
    }

    public RestExternalRepository(ExternalRepository externalRepository) {
        this.put(CLONE_URL, externalRepository.getCloneUrl());
        this.put(DESCRIPTION, externalRepository.getDescription());
        this.put(NAME, externalRepository.getName());
        this.put(SCM_ID, externalRepository.getScmId());
    }

    @Override
    @Nonnull
    @NotNull
    public String getCloneUrl() {
        return this.getStringProperty(CLONE_URL);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @Override
    @Nonnull
    @NotNull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Override
    @Nonnull
    @NotNull
    public String getScmId() {
        return this.getStringProperty(SCM_ID);
    }

    @Nullable
    public static ExternalRepository valueOf(@Nullable Object value) {
        if (value instanceof RestExternalRepository) {
            return (RestExternalRepository)value;
        }
        if (value instanceof Map) {
            return new RestExternalRepository((Map)value);
        }
        return null;
    }
}

