/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.rest;

import com.atlassian.bitbucket.internal.importer.repository.ImportJob;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTask;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=ImportJob.class)
public class RestRepositoryImportTask
extends RestMapEntity {
    public static final String CLONE_URL = "cloneUrl";
    public static final String CREATED = "created";
    public static final String EXTERNAL_REPO_NAME = "externalRepoName";
    public static final String FAILURE_TYPE = "failureType";
    public static final String IMPORT_TASK_STATE = "state";
    public static final String LAST_UPDATED = "lastUpdated";
    public static final String REPOSITORY = "repository";
    public static final String TASK_ID = "taskId";

    public RestRepositoryImportTask(RepositoryImportTask task) {
        this.put(CLONE_URL, task.getCloneUrl());
        this.put(CREATED, task.getCreated());
        this.put(EXTERNAL_REPO_NAME, task.getExternalRepoName());
        this.put(FAILURE_TYPE, (Object)task.getFailureType());
        this.put(IMPORT_TASK_STATE, (Object)task.getState());
        this.put(LAST_UPDATED, task.getLastUpdated());
        this.put(TASK_ID, task.getTaskId());
        task.getRepository().ifPresent(repository -> this.put(REPOSITORY, new RestRepository(repository, true)));
    }
}

