/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.validation;

import com.atlassian.bitbucket.internal.importer.validation.CloneUrl;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneUrlValidator
implements ConstraintValidator<CloneUrl, String> {
    private static final Logger log = LoggerFactory.getLogger(CloneUrlValidator.class);

    public void initialize(CloneUrl constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        try {
            URI uri = new URI(value);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("git") || StringUtils.isEmpty((CharSequence)uri.getHost()) || uri.getAuthority().endsWith(":") || !CloneUrlValidator.isValidUrlPart(URLDecoder.decode(uri.getPath(), StandardCharsets.UTF_8.name())) || !CloneUrlValidator.isValidUrlPart(uri.getQuery())) {
                return false;
            }
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            log.debug("Failed to validate url: {}", (Object)value, (Object)e);
            return false;
        }
        return true;
    }

    private static boolean isValidUrlPart(@Nullable String uriPart) {
        if (uriPart == null) {
            return true;
        }
        return uriPart.chars().noneMatch(Character::isISOControl);
    }
}

