/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.web;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskState;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportService;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTask;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AnonymousSiteAccess
@Component
public class RepositoryImportFilter
implements Filter {
    private static final String PROJECTS = "projects";
    private static final String REPOS = "repos";
    private static final String SETTINGS = "settings";
    private final NavBuilder navBuilder;
    private final RepositoryImportService repositoryImportService;
    private final RepositoryService repositoryService;

    @Autowired
    public RepositoryImportFilter(NavBuilder navBuilder, RepositoryImportService repositoryImportService, RepositoryService repositoryService) {
        this.repositoryImportService = repositoryImportService;
        this.repositoryService = repositoryService;
        this.navBuilder = navBuilder;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ImportTaskState importTaskState;
        Optional<RepositoryImportTask> importTask;
        Repository repository;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if ("GET".equals(httpServletRequest.getMethod()) && (repository = this.getRepository(this.getPathParts(httpServletRequest))) != null && (importTask = this.repositoryImportService.getRepositoryImportTask(repository)).isPresent() && (importTaskState = importTask.get().getState()) != ImportTaskState.SUCCESS && importTaskState != ImportTaskState.FAILED) {
            ((HttpServletResponse)response).sendRedirect(this.navBuilder.pluginServlets().path(new String[]{"import-in-process", PROJECTS, repository.getProject().getKey(), REPOS, repository.getSlug()}).buildRelative());
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private String[] getPathParts(HttpServletRequest httpRequest) {
        String pathInfo = httpRequest.getPathInfo();
        if (pathInfo != null && !pathInfo.isEmpty()) {
            return pathInfo.substring(1).split("/");
        }
        return null;
    }

    private Repository getRepository(String[] pathParts) {
        if (pathParts != null && pathParts.length > 3 && PROJECTS.equals(pathParts[0]) && REPOS.equals(pathParts[2])) {
            return this.repositoryService.getBySlug(pathParts[1], pathParts[3]);
        }
        return null;
    }
}

