/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.web;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.bitbucket.internal.importer.repository.ImportTaskState;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportService;
import com.atlassian.bitbucket.internal.importer.repository.RepositoryImportTask;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

@AnonymousSiteAccess
public class RepositoryImportInProgressServlet
extends HttpServlet {
    public static final String PROJECTS = "projects";
    public static final String REPOS = "repos";
    private static final String IMPORT_PAGE_TEMPLATE_KEY = "bitbucketPluginImporter.internal.importInProgress.importRepositoryInProgress.importInProgress";
    private static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-importer:import-in-progress-page";
    private final NavBuilder navBuilder;
    private final PermissionValidationService permissionValidationService;
    private final RepositoryImportService repositoryImportService;
    private final RepositoryService repositoryService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public RepositoryImportInProgressServlet(NavBuilder navBuilder, PermissionValidationService permissionValidationService, RepositoryImportService repositoryImportService, RepositoryService repositoryService, SoyTemplateRenderer soyTemplateRenderer) {
        this.navBuilder = navBuilder;
        this.permissionValidationService = permissionValidationService;
        this.repositoryImportService = repositoryImportService;
        this.repositoryService = repositoryService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Repository repository = this.getRepository(req);
        if (repository == null) {
            resp.sendError(404);
            return;
        }
        this.permissionValidationService.validateRepositoryAccessible(repository.getId());
        Optional<RepositoryImportTask> importTask = this.repositoryImportService.getRepositoryImportTask(repository);
        if (!importTask.isPresent()) {
            this.redirect(resp, repository);
            return;
        }
        ImportTaskState state = importTask.get().getState();
        if (state != ImportTaskState.QUEUED && state != ImportTaskState.STARTED) {
            this.redirect(resp, repository);
            return;
        }
        this.render(resp, (Map<String, Object>)ImmutableMap.of((Object)"repository", (Object)repository));
    }

    private Repository getRepository(HttpServletRequest httpRequest) {
        String pathInfo = httpRequest.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            return null;
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        return pathParts.length > 3 && PROJECTS.equals(pathParts[0]) && REPOS.equals(pathParts[2]) ? this.repositoryService.getBySlug(pathParts[1], pathParts[3]) : null;
    }

    private void redirect(HttpServletResponse resp, Repository repository) throws IOException {
        resp.sendRedirect(this.navBuilder.project(repository.getProject()).repo(repository.getSlug()).browse().buildAbsolute());
    }

    private void render(HttpServletResponse resp, Map<String, Object> repository) throws IOException {
        resp.setContentType(MediaType.HTML_UTF_8.toString());
        this.soyTemplateRenderer.render((Appendable)resp.getWriter(), RESOURCE_KEY, IMPORT_PAGE_TEMPLATE_KEY, repository);
    }
}

