/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.importer.web;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.internal.importer.ImporterConstants;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

@LicensedOnly
public class RepositoryImportServlet
extends HttpServlet {
    static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-importer:server-side-templates";
    private static final String IMPORT_PAGE_TEMPLATE_KEY = "bitbucketPluginImporter.internal.page.importRepositoryServer.importRepo";
    private final PermissionValidationService permissionValidationService;
    private final ProjectService projectService;
    private final ApplicationPropertiesService propertiesService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public RepositoryImportServlet(PermissionValidationService permissionValidationService, ProjectService projectService, ApplicationPropertiesService propertiesService, SoyTemplateRenderer soyTemplateRenderer) {
        this.permissionValidationService = permissionValidationService;
        this.projectService = projectService;
        this.propertiesService = propertiesService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Optional<Project> maybeProject = this.getProject(req.getPathInfo());
        if (!maybeProject.isPresent()) {
            resp.sendError(404);
            return;
        }
        Project project = maybeProject.get();
        this.permissionValidationService.validateForProject(project.getId(), Permission.REPO_CREATE);
        ImmutableMap.Builder data = ImmutableMap.builder();
        data.put((Object)"project", (Object)project);
        data.put((Object)"fetchTimeout", (Object)this.propertiesService.getPluginProperty("plugin.importer.repository.fetch.timeout.execution", ImporterConstants.PROPERTY_REPO_FETCH_TIMEOUT_EXEC_DEFAULT));
        this.render(resp, (Map<String, Object>)data.build());
    }

    private void render(HttpServletResponse resp, Map<String, Object> data) throws IOException {
        resp.setContentType(MediaType.HTML_UTF_8.toString());
        this.soyTemplateRenderer.render((Appendable)resp.getWriter(), RESOURCE_KEY, IMPORT_PAGE_TEMPLATE_KEY, data);
    }

    private Optional<Project> getProject(String pathInfo) {
        if (Strings.isNullOrEmpty((String)pathInfo) || pathInfo.equals("/")) {
            return Optional.empty();
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        if (pathParts.length < 1) {
            return Optional.empty();
        }
        String projectKey = pathParts[0];
        Project project = this.projectService.getByKey(projectKey);
        return Optional.ofNullable(project);
    }
}

