/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.binary;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.scm.git.binary.GitBinary;
import com.atlassian.stash.internal.scm.git.binary.GitBinaryHelper;
import com.atlassian.stash.internal.scm.git.binary.RejectedGitBinary;
import com.atlassian.stash.internal.scm.git.binary.SimpleGitBinary;
import com.atlassian.stash.internal.scm.git.version.VersionCommand;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGitBinaryHelper
implements GitBinaryHelper {
    static final List<String> DEFAULT_LOCATIONS = ImmutableList.of((Object)"/usr/bin", (Object)"/bin", (Object)"/usr/sbin", (Object)"/sbin", (Object)"/usr/local/bin", (Object)"/opt/local/bin", (Object)"/usr/local/git/bin", (Object)"/opt/bin", (Object)(SystemUtils.USER_HOME + "/bin"));
    static final List<String> DEFAULT_LOCATIONS_WINDOWS = ImmutableList.of((Object)"C:\\Program Files (x86)\\Git\\bin", (Object)"C:\\Program Files\\Git\\bin", (Object)"C:\\Cygwin\\bin", (Object)"C:\\Git\\bin");
    static final Set<String> WINDOWS_WORLD_GROUPS = ImmutableSet.of((Object)"everyone", (Object)"users", (Object)"authenticated users", (Object)"guest", (Object)"power users");
    private static final Logger log = LoggerFactory.getLogger(DefaultGitBinaryHelper.class);
    private static final Set<Version> DEFAULT_RESTRICTED_MINOR_VERSIONS = ImmutableSet.of((Object)new Version(new Integer[]{2, 48}));
    private static final Set<Version> DEFAULT_RESTRICTED_PATCH_VERSIONS = Collections.emptySet();
    @VisibleForTesting
    final Set<Version> restrictedMinorVersions;
    @VisibleForTesting
    final Set<Version> restrictedPatchVersions;
    private Version unsupportedFromVersion;

    public DefaultGitBinaryHelper() {
        this.restrictedMinorVersions = DEFAULT_RESTRICTED_MINOR_VERSIONS;
        this.restrictedPatchVersions = DEFAULT_RESTRICTED_PATCH_VERSIONS;
    }

    public DefaultGitBinaryHelper(Set<Version> restrictedMinorVersions, Set<Version> restrictedPatchVersions) {
        this.restrictedMinorVersions = ImmutableSet.copyOf(restrictedMinorVersions);
        this.restrictedPatchVersions = ImmutableSet.copyOf(restrictedPatchVersions);
    }

    @Override
    @Nonnull
    public String applyExtension(@Nonnull String executable) {
        Objects.requireNonNull(executable, "executable");
        if (this.isWindows() && FilenameUtils.indexOfExtension((String)executable) == -1) {
            executable = (String)executable + ".exe";
        }
        return executable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nonnull
    public Either<RejectedGitBinary, GitBinary> find(String configuredLocation) {
        if (!StringUtils.isNotBlank((CharSequence)configuredLocation)) return this.either(this.findIn(this.getSearchPaths()));
        File executable = new File(configuredLocation = this.applyExtension(configuredLocation));
        if (!DefaultGitBinaryHelper.isExecutable(executable)) {
            log.warn("The configured git executable, {}, does not exist or is not executable", (Object)configuredLocation);
            return this.either(this.findIn(this.getSearchPaths()));
        }
        log.trace("Checking the configured git executable: {}", (Object)configuredLocation);
        Option<Version> option = this.versionOf(executable);
        if (option.isEmpty()) {
            log.warn("The configured git executable, {}, is not valid", (Object)configuredLocation);
            return this.either(this.findIn(this.getSearchPaths()));
        }
        if (MINIMUM_VERSION.compareTo((Version)option.get()) > 0) {
            log.warn("The configured git executable, {}, is version {}; {} is the minimum required version", new Object[]{configuredLocation, option.get(), MINIMUM_VERSION});
            return this.either(this.findIn(this.getSearchPaths()));
        }
        if (this.restrictedMinorVersions.stream().anyMatch(restricted -> restricted.getMajor() == ((Version)option.get()).getMajor() && restricted.getMinor() == ((Version)option.get()).getMinor())) {
            String unsupportedMinorVersion = ((Version)option.get()).getMajor() + "." + ((Version)option.get()).getMinor();
            log.warn("The configured git executable, {}, is version {}. Git {}.x is not supported due to critical regressions which break core {} functionality", new Object[]{configuredLocation, option.get(), unsupportedMinorVersion, Product.NAME});
            return this.either(this.findIn(this.getSearchPaths()));
        }
        if (this.restrictedPatchVersions.contains(option.get())) {
            log.warn("The configured git executable, {}, is version {}. This version is not supported due to critical regressions which break core {} functionality", new Object[]{configuredLocation, option.get(), Product.NAME});
            return this.either(this.findIn(this.getSearchPaths()));
        }
        if (this.unsupportedFromVersion != null && this.unsupportedFromVersion.compareTo((Version)option.get()) <= 0) {
            log.warn("The configured git executable, {}, is version {} which is unsupported because git {} and higher (may) contain changes which break core {} functionality", new Object[]{configuredLocation, option.get(), this.unsupportedFromVersion, Product.NAME});
            return this.either(this.findIn(this.getSearchPaths()));
        }
        log.debug("Using explicitly configured git executable at {}", (Object)configuredLocation);
        return DefaultGitBinaryHelper.foundBinary(new SimpleGitBinary(executable.getAbsolutePath(), (Version)option.get()));
    }

    public void setUnsupportedFromVersion(Version value) {
        this.unsupportedFromVersion = value;
    }

    public void setUnsupportedFromVersion(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                this.unsupportedFromVersion = new Version(value);
            }
            catch (RuntimeException e) {
                log.warn("Not a valid version: {}", (Object)value, (Object)e);
            }
        }
    }

    @Nonnull
    @VisibleForTesting
    protected Iterable<String> getSearchPaths() {
        LoggingIterable paths;
        String path = System.getenv("PATH");
        if (path == null) {
            log.debug("PATH was not set");
            paths = null;
        } else {
            paths = new LoggingIterable("PATH", (Iterable<String>)ImmutableList.copyOf((Object[])path.split(File.pathSeparator)));
        }
        LoggingIterable defaults = new LoggingIterable("default locations", this.isWindows() ? DEFAULT_LOCATIONS_WINDOWS : DEFAULT_LOCATIONS);
        return paths == null ? defaults : Iterables.concat((Iterable)paths, (Iterable)defaults);
    }

    @VisibleForTesting
    protected boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    @VisibleForTesting
    protected Option<Version> versionOf(File executable) {
        String path = executable.getAbsolutePath();
        Version version = null;
        try {
            version = new VersionCommand(path).call();
        }
        catch (Exception e) {
            log.warn("Could not execute " + path, (Throwable)e);
        }
        return Option.option((Object)version);
    }

    private static Either<RejectedGitBinary, GitBinary> foundBinary(GitBinary binary) {
        Version version = binary.getVersion();
        if (NEXT_MINIMUM_VERSION.compareTo(version) > 0) {
            log.warn("{} is version {}. The next major {} version will require Git {} or higher.", new Object[]{binary.getPath(), version, Product.NAME, NEXT_MINIMUM_VERSION});
        }
        return Either.right((Object)binary);
    }

    private static boolean isExecutable(File executable) {
        return executable.isFile() && executable.canExecute();
    }

    private static boolean isWorldWritable(File executable) throws IOException {
        try {
            Path path = executable.toPath();
            if (MoreFiles.isPosixSupported((Path)path)) {
                return Files.getPosixFilePermissions(path, new LinkOption[0]).contains((Object)PosixFilePermission.OTHERS_WRITE);
            }
            if (MoreFiles.isAclSupported((Path)path)) {
                return Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]).getAcl().stream().filter(acl -> acl.permissions().contains((Object)AclEntryPermission.WRITE_DATA)).anyMatch(acl -> WINDOWS_WORLD_GROUPS.stream().anyMatch(worldGroup -> {
                    String principal = acl.principal().getName();
                    int split = principal.lastIndexOf("\\");
                    if (split != -1) {
                        principal = principal.substring(split + 1);
                    }
                    return WINDOWS_WORLD_GROUPS.contains(principal.toLowerCase(Locale.ROOT));
                }));
            }
            log.warn("Could not check permissions for {}; assuming that the binary is safe to use", (Object)executable);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
        return false;
    }

    @Nonnull
    private Either<RejectedGitBinary, GitBinary> either(GitBinary binary) {
        if (binary == null) {
            if (this.restrictedMinorVersions.isEmpty() && this.restrictedPatchVersions.isEmpty()) {
                return Either.left((Object)new RejectedGitBinary(new I18nKey("bitbucket.git.notfound.noexcludes", new Object[]{Product.NAME, MINIMUM_VERSION})));
            }
            return Either.left((Object)new RejectedGitBinary(new I18nKey("bitbucket.git.notfound", new Object[]{Product.NAME, MINIMUM_VERSION, this.restrictedVersions()})));
        }
        Version version = binary.getVersion();
        if (MINIMUM_VERSION.compareTo(version) > 0) {
            if (this.restrictedMinorVersions.isEmpty() && this.restrictedPatchVersions.isEmpty()) {
                return Either.left((Object)new RejectedGitBinary(new I18nKey("bitbucket.git.versiontooold.noexcludes", new Object[]{Product.NAME, MINIMUM_VERSION, version}), binary));
            }
            return Either.left((Object)new RejectedGitBinary(new I18nKey("bitbucket.git.versiontooold", new Object[]{Product.NAME, MINIMUM_VERSION, this.restrictedVersions(), version}), binary));
        }
        if (this.restrictedPatchVersions.contains(version) || this.restrictedMinorVersions.stream().anyMatch(restricted -> restricted.getMajor() == version.getMajor() && restricted.getMinor() == version.getMinor())) {
            return Either.left((Object)new RejectedGitBinary(new I18nKey("bitbucket.git.versionrestricted", new Object[]{Product.NAME, MINIMUM_VERSION, this.restrictedVersions(), version}), binary));
        }
        if (this.unsupportedFromVersion != null && this.unsupportedFromVersion.compareTo(version) <= 0) {
            return Either.left((Object)new RejectedGitBinary(new I18nKey("bitbucket.git.versiontoonew", new Object[]{Product.NAME, version}), binary));
        }
        return DefaultGitBinaryHelper.foundBinary(binary);
    }

    private Option<File> executableFor(String path) {
        File directory = new File(path);
        File executable = new File(directory, this.applyExtension("git"));
        if (DefaultGitBinaryHelper.isExecutable(executable)) {
            try {
                if (DefaultGitBinaryHelper.isWorldWritable(executable)) {
                    log.warn("{} will be ignored because it is world-writable and could be exploited.", (Object)executable);
                    return Option.none();
                }
            }
            catch (IOException e) {
                log.warn("Could not check permissions for {}; will not check version", (Object)executable, (Object)e);
                return Option.none();
            }
            return Option.some((Object)executable);
        }
        return Option.none();
    }

    private GitBinary findIn(Iterable<String> paths) {
        SimpleGitBinary found = null;
        boolean foundIsSupported = false;
        for (String path : paths) {
            log.trace("Looking for Git executable in {}", (Object)path);
            for (File executable : this.executableFor(path)) {
                log.trace("Checking version for {}", (Object)executable);
                for (Version version : this.versionOf(executable)) {
                    SimpleGitBinary binary = new SimpleGitBinary(executable.getAbsolutePath(), version);
                    boolean supported = this.isSupported(version);
                    log.debug("Found git version {} at {}", (Object)version, (Object)executable);
                    if (supported && version.compareTo(NEXT_MINIMUM_VERSION) > -1) {
                        return binary;
                    }
                    if (found == null) {
                        found = binary;
                        foundIsSupported = supported;
                        continue;
                    }
                    if (foundIsSupported == supported) {
                        if (version.compareTo(found.getVersion()) <= 0) continue;
                        found = binary;
                        continue;
                    }
                    if (!supported) continue;
                    found = binary;
                    foundIsSupported = true;
                }
            }
        }
        return found;
    }

    private boolean isSupported(Version version) {
        for (Version restricted : this.restrictedMinorVersions) {
            if (restricted.getMajor() != version.getMajor() || restricted.getMinor() != version.getMinor()) continue;
            return false;
        }
        return !this.restrictedPatchVersions.contains(version) && MINIMUM_VERSION.compareTo(version) <= 0 && (this.unsupportedFromVersion == null || this.unsupportedFromVersion.compareTo(version) > 0);
    }

    private String restrictedVersions() {
        return Stream.concat(this.restrictedMinorVersions.stream().map(version -> version.getMajor() + "." + version.getMinor() + ".x"), this.restrictedPatchVersions.stream().map(Version::toString)).collect(Collectors.joining(", "));
    }

    private static class LoggingIterable
    implements Iterable<String> {
        private final Iterable<String> delegate;
        private final String type;

        private LoggingIterable(String type, Iterable<String> delegate) {
            this.delegate = delegate;
            this.type = type;
        }

        @Override
        @Nonnull
        public Iterator<String> iterator() {
            log.debug("Searching {} for git executable", (Object)this.type);
            return this.delegate.iterator();
        }
    }
}

