/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.version;

import com.atlassian.bitbucket.scm.AsyncCommand;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.util.Version;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionCommand
implements Command<Version> {
    private static final Pattern PATTERN_VERSION = Pattern.compile("^git version (.*)");
    private final String binary;

    public VersionCommand(String binary) {
        this.binary = binary;
    }

    @Nullable
    public static Version parse(@Nonnull String line) {
        Matcher matcher = PATTERN_VERSION.matcher(line);
        if (matcher.matches()) {
            return new Version(matcher.group(1));
        }
        return null;
    }

    @Nonnull
    public AsyncCommand<Version> asynchronous() {
        throw new UnsupportedOperationException("git version cannot be executed asynchronously");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Version call() {
        try {
            Process process = new ProcessBuilder(this.binary, "version").start();
            try (InputStream inputStream = process.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                Version version;
                do {
                    if ((line = reader.readLine()) == null) return null;
                } while ((version = VersionCommand.parse(line)) == null);
                Version version2 = version;
                return version2;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("[" + this.binary + " version] could not be started", e);
        }
    }

    public void setExecutionTimeout(long timeoutInSecs) {
    }

    public void setIdleTimeout(long timeoutInSecs) {
    }
}

