/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepository;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepositoryService;
import com.atlassian.bitbucket.dmz.secretscanning.RepositoryExemptAlreadyExistsException;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningExemptRepositoryOrder;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.secretscanning.dao.SecretScanningExemptRepositoryDao;
import com.atlassian.bitbucket.internal.secretscanning.event.SecretScanningExemptRepoAddedEvent;
import com.atlassian.bitbucket.internal.secretscanning.event.SecretScanningExemptRepoDeletedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.secretscanning.InternalSecretScanningExemptRepository;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

@RequireFeature(value=StandardFeature.SECRET_SCANNING)
@Transactional(readOnly=true)
public class DefaultSecretScanningExemptRepositoryService
implements DmzSecretScanningExemptRepositoryService {
    private final EventPublisher eventPublisher;
    private final SecretScanningExemptRepositoryDao exemptRepositoryDao;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final InternalApplicationPropertiesService propertiesService;

    public DefaultSecretScanningExemptRepositoryService(EventPublisher eventPublisher, SecretScanningExemptRepositoryDao exemptRepositoryDao, I18nService i18nService, PermissionValidationService permissionValidationService, InternalApplicationPropertiesService propertiesService) {
        this.eventPublisher = eventPublisher;
        this.exemptRepositoryDao = exemptRepositoryDao;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.propertiesService = propertiesService;
    }

    @Transactional
    public void add(Repository repository, Scope scope) {
        Objects.requireNonNull(repository, "repository");
        this.add((List<Repository>)ImmutableList.of((Object)repository), scope);
    }

    @Transactional
    public void add(List<Repository> repositories, Scope scope) {
        Objects.requireNonNull(repositories, "repositories");
        this.validateAdminPermission(scope, false);
        this.validateExistingExemptions(repositories);
        repositories.forEach(repository -> {
            this.validateRepoInScope((Repository)repository, scope);
            this.exemptRepositoryDao.create(new InternalSecretScanningExemptRepository.Builder(repository).scope(scope).build());
            this.eventPublisher.publish((Object)new SecretScanningExemptRepoAddedEvent(this, (Repository)repository));
        });
    }

    @Transactional
    public void delete(Repository repository) {
        Objects.requireNonNull(repository, "repository");
        InternalSecretScanningExemptRepository existing = (InternalSecretScanningExemptRepository)this.exemptRepositoryDao.getById(repository.getId());
        if (existing == null) {
            return;
        }
        this.validateAdminPermission(existing.getScope(), false);
        this.exemptRepositoryDao.deleteById(repository.getId());
        this.eventPublisher.publish((Object)new SecretScanningExemptRepoDeletedEvent(this, repository));
    }

    public Page<DmzSecretScanningExemptRepository> findByScope(Scope scope, SecretScanningExemptRepositoryOrder order, PageRequest pageRequest) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Objects.requireNonNull(order, "order");
        this.validateAdminPermission(scope, true);
        return PageUtils.asPageOf(DmzSecretScanningExemptRepository.class, this.exemptRepositoryDao.findByScope(scope, order, pageRequest));
    }

    public boolean isExempt(Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
        if (repository.getProject().getType() == ProjectType.PERSONAL && this.isPersonalReposExempt()) {
            return true;
        }
        return this.exemptRepositoryDao.getById(repository.getId()) != null;
    }

    public boolean isPersonalReposExempt() {
        return !this.propertiesService.isSecretScanningEnabledForPrivateRepositories();
    }

    @Transactional
    public void setExemptPersonalRepositories(boolean value) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        this.propertiesService.setSecretScanningEnabledForPrivateRepositories(!value);
    }

    private void validateAdminPermission(Scope scope, final boolean allowRepoScope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(GlobalScope globalScope) {
                DefaultSecretScanningExemptRepositoryService.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return null;
            }

            public Void visit(ProjectScope projectScope) {
                DefaultSecretScanningExemptRepositoryService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(RepositoryScope repositoryScope) {
                if (allowRepoScope) {
                    DefaultSecretScanningExemptRepositoryService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_ADMIN);
                    return null;
                }
                throw new ArgumentValidationException(DefaultSecretScanningExemptRepositoryService.this.i18nService.createKeyedMessage("bitbucket.secretscanning.error.exemptrepo.reposcopenotallowed", new Object[0]));
            }
        });
    }

    private void validateExistingExemptions(List<Repository> repositories) {
        List<InternalSecretScanningExemptRepository> existing = this.exemptRepositoryDao.getByRepositoryIds(repositories.stream().map(Repository::getId).collect(Collectors.toSet()));
        if (existing.isEmpty()) {
            return;
        }
        Set repositoryIds = (Set)existing.stream().map(InternalSecretScanningExemptRepository::getRepositoryId).collect(MoreCollectors.toImmutableSet());
        if (existing.size() == 1) {
            InternalSecretScanningExemptRepository exemptRepository = (InternalSecretScanningExemptRepository)existing.stream().findFirst().get();
            Repository repository = exemptRepository.getRepository();
            String repoFullSlug = repository.getProject().getKey() + "/" + repository.getSlug();
            throw new RepositoryExemptAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.secretscanning.error.exemptrepo.alreadyexists.single", new Object[]{repoFullSlug, exemptRepository.getScope().getType()}), repositoryIds);
        }
        throw new RepositoryExemptAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.secretscanning.error.exemptrepo.alreadyexists.multiple", new Object[0]), repositoryIds);
    }

    private void validateRepoInScope(final Repository repository, Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(ProjectScope projectScope) {
                if (!repository.getProject().equals((Object)projectScope.getProject())) {
                    throw new AuthorisationException(DefaultSecretScanningExemptRepositoryService.this.i18nService.createKeyedMessage("bitbucket.secretscanning.error.exemptrepo.reponotinproject", new Object[]{repository.getId()}));
                }
                return null;
            }
        });
    }
}

