/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning;

import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningIncompleteEvent;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretsDetectedEvent;
import com.atlassian.bitbucket.dmz.secretscanning.scan.SecretScanResult;
import com.atlassian.bitbucket.internal.secretscanning.SecretScanningService;
import com.atlassian.bitbucket.internal.secretscanning.async.SecretScanningProcessingUpdated;
import com.atlassian.bitbucket.internal.secretscanning.rules.SecretScanningConfiguration;
import com.atlassian.bitbucket.internal.secretscanning.rules.SecretScanningConfigurationProvider;
import com.atlassian.bitbucket.internal.secretscanning.scan.CommitSecretScanner;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequireFeature(value=StandardFeature.SECRET_SCANNING)
public class DefaultSecretScanningService
implements SecretScanningService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretScanningService.class);
    private final CommitSecretScanner commitSecretScanner;
    private final EventPublisher eventPublisher;
    private final Topic<SecretScanningProcessingUpdated> scanningUpdatedTopic;
    private final SecretScanningConfigurationProvider secretScanningConfigurationProvider;

    public DefaultSecretScanningService(CommitSecretScanner commitSecretScanner, EventPublisher eventPublisher, SecretScanningConfigurationProvider secretScanningConfigurationProvider, TopicService topicService) {
        this.commitSecretScanner = commitSecretScanner;
        this.eventPublisher = eventPublisher;
        this.secretScanningConfigurationProvider = secretScanningConfigurationProvider;
        this.scanningUpdatedTopic = topicService.getTopic("secretscanning:queue.updated", TopicSettings.builder(SecretScanningProcessingUpdated.class).build());
    }

    @Override
    public void onCommits(Repository repository, List<String> commitIds, @Nullable ApplicationUser initiatingUser) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commitIds, "commits");
        if (commitIds.isEmpty()) {
            return;
        }
        log.trace("Starting secret scan on {} commits in {}", (Object)commitIds.size(), (Object)repository);
        ArrayList foundSecrets = new ArrayList();
        SecretScanningConfiguration configuration = this.secretScanningConfigurationProvider.getConfiguration((Scope)Scopes.repository((Repository)repository));
        try (Timer ignored = TimerUtils.start((String)String.format("Secret scanning for %s from %s..%s", repository, commitIds.get(0), commitIds.get(commitIds.size() - 1)));){
            for (String commitId : commitIds) {
                SecretScanResult scanResult = this.commitSecretScanner.scanCommit(repository, commitId, configuration);
                foundSecrets.addAll(scanResult.getSecretLocations());
                if (!scanResult.isTruncated() && !scanResult.failed()) continue;
                this.eventPublisher.publish((Object)new SecretScanningIncompleteEvent(initiatingUser, repository, scanResult, (Object)this));
            }
        }
        if (!foundSecrets.isEmpty()) {
            log.debug("Found {} secrets in {}", (Object)foundSecrets.size(), (Object)repository);
            this.eventPublisher.publish((Object)new SecretsDetectedEvent(repository, foundSecrets, initiatingUser, (Object)this));
        }
        this.scanningUpdatedTopic.publish((Serializable)new SecretScanningProcessingUpdated(SecretScanningProcessingUpdated.Type.COMPLETED, String.valueOf(repository.getId()), commitIds.size()));
    }
}

