/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepositoryService;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretScanningCommitLimitReachedEvent;
import com.atlassian.bitbucket.hook.repository.CommitAddedDetails;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.internal.secretscanning.SecretScanningService;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretScanningHook
implements PostRepositoryHook<RepositoryHookRequest> {
    @VisibleForTesting
    static final String IS_REF_SYNC_KEY = "isRefSync";
    private static final Set<RepositoryHookTrigger> ALLOWED_TRIGGERS = ImmutableSet.of((Object)StandardRepositoryHookTrigger.BRANCH_CREATE, (Object)StandardRepositoryHookTrigger.FILE_EDIT, (Object)StandardRepositoryHookTrigger.MERGE, (Object)StandardRepositoryHookTrigger.PULL_REQUEST_MERGE, (Object)StandardRepositoryHookTrigger.REPO_PUSH, (Object)StandardRepositoryHookTrigger.UNKNOWN, (Object[])new RepositoryHookTrigger[0]);
    private static final int DEFAULT_BATCH_SIZE = 200;
    private static final int DEFAULT_COMMIT_LIMIT = 10000;
    private static final Logger log = LoggerFactory.getLogger(SecretScanningHook.class);
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final DmzSecretScanningExemptRepositoryService exemptRepositoryService;
    private final FeatureManager featureManager;
    private final InternalApplicationPropertiesService propertiesService;
    private final SecretScanningService secretScanningService;

    public SecretScanningHook(AuthenticationContext authenticationContext, EventPublisher eventPublisher, FeatureManager featureManager, InternalApplicationPropertiesService propertiesService, DmzSecretScanningExemptRepositoryService exemptRepositoryService, SecretScanningService secretScanningService) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.exemptRepositoryService = exemptRepositoryService;
        this.featureManager = featureManager;
        this.propertiesService = propertiesService;
        this.secretScanningService = secretScanningService;
    }

    public void postUpdate(PostRepositoryHookContext context, RepositoryHookRequest request) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(request, "request");
        if (this.shouldTriggerScan(request)) {
            context.registerCommitCallback((RepositoryHookCommitCallback)new SecretScanningHookCallback(request.getRepository(), this.authenticationContext.getCurrentUser()), RepositoryHookCommitFilter.ADDED_TO_REPOSITORY, new RepositoryHookCommitFilter[0]);
        }
    }

    private boolean shouldTriggerScan(RepositoryHookRequest request) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.SECRET_SCANNING)) {
            return false;
        }
        if (!ALLOWED_TRIGGERS.contains(request.getTrigger())) {
            return false;
        }
        if (request.getContext().containsKey(IS_REF_SYNC_KEY)) {
            return false;
        }
        if (request.getRepository().getProject().getType() == ProjectType.PERSONAL && !this.propertiesService.isSecretScanningEnabledForPrivateRepositories()) {
            return false;
        }
        return !this.exemptRepositoryService.isExempt(request.getRepository());
    }

    private class SecretScanningHookCallback
    implements RepositoryHookCommitCallback {
        private final int batchSize;
        private final int commitScanLimit;
        private final ApplicationUser initiatingUser;
        private final Repository repository;
        private Set<String> commits;
        private int commitsProcessed;

        SecretScanningHookCallback(@Nullable Repository repository, ApplicationUser initiatingUser) {
            this.batchSize = SecretScanningHook.this.propertiesService.getProperty("secretscanning.scan.batch.size", 200);
            this.commitScanLimit = SecretScanningHook.this.propertiesService.getProperty("secretscanning.scan.commit.limit", 10000);
            this.commits = new HashSet<String>(this.batchSize, 1.0f);
            this.repository = Objects.requireNonNull(repository, "repository");
            this.initiatingUser = initiatingUser;
        }

        public boolean onCommitAdded(@Nonnull CommitAddedDetails commitDetails) {
            this.commits.add(Objects.requireNonNull(commitDetails, "commitDetails").getCommit().getId());
            if (this.commits.size() >= this.batchSize) {
                this.commitsProcessed += this.commits.size();
                this.sendCommitsForScanning(false);
                if (this.commitsProcessed >= this.commitScanLimit) {
                    SecretScanningHook.this.eventPublisher.publish((Object)new SecretScanningCommitLimitReachedEvent((Object)this, this.initiatingUser, this.repository));
                    log.warn("Reached the commit limit when scanning secrets for {}", (Object)this.repository.getSlug());
                    return false;
                }
            }
            return true;
        }

        public void onEnd() {
            if (!this.commits.isEmpty()) {
                this.sendCommitsForScanning(true);
            }
        }

        private void sendCommitsForScanning(boolean onEnd) {
            SecretScanningHook.this.secretScanningService.onCommits(this.repository, (List<String>)ImmutableList.copyOf(this.commits), this.initiatingUser);
            if (!onEnd) {
                this.commits = new HashSet<String>(this.batchSize, 1.0f);
            }
        }
    }
}

