/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.async;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.internal.secretscanning.SecretScanningService;
import com.atlassian.bitbucket.internal.secretscanning.async.AsyncSecretScanningRequest;
import com.atlassian.bitbucket.internal.secretscanning.async.SecretScanningProcessingUpdated;
import com.atlassian.bitbucket.internal.secretscanning.async.SecretScanningProcessor;
import com.atlassian.bitbucket.internal.secretscanning.jmx.SecretScanningProcessorMXBean;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@RequireFeature(value=StandardFeature.SECRET_SCANNING)
@Service(value="asyncSecretScanningService")
public class AsyncSecretScanningService
implements SecretScanningService {
    @VisibleForTesting
    static final String MXBEAN_NAME = "com.atlassian.bitbucket:name=SecretScanningExecutor";
    private static final String BUCKETED_EXECUTOR_NAME = "secret-scanning";
    private static final Logger log = LoggerFactory.getLogger(AsyncSecretScanningService.class);
    private final BucketedExecutor<AsyncSecretScanningRequest> bucketedExecutor;
    private final boolean jmxEnabled;
    private final ConcurrentMap<String, Integer> queueSize = new ConcurrentHashMap<String, Integer>();
    private final Topic<SecretScanningProcessingUpdated> scanningUpdatedTopic;
    private String subscriptionId;

    public AsyncSecretScanningService(ApplicationPropertiesService propertiesService, ConcurrencyService concurrencyService, int maxConcurrency, SecretScanningProcessor secretScanningProcessor, TopicService topicService) {
        this.jmxEnabled = propertiesService.isJmxEnabled();
        this.bucketedExecutor = concurrencyService.getBucketedExecutor(BUCKETED_EXECUTOR_NAME, new BucketedExecutorSettings.Builder(AsyncSecretScanningService.toBucketId(), (BucketProcessor)secretScanningProcessor).maxConcurrency(maxConcurrency, ConcurrencyPolicy.PER_NODE).maxAttempts(1).build());
        this.scanningUpdatedTopic = topicService.getTopic("secretscanning:queue.updated", TopicSettings.builder(SecretScanningProcessingUpdated.class).build());
    }

    @Override
    public void onCommits(Repository repository, List<String> commitIds, @Nullable ApplicationUser initiatingUser) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commitIds, "commits");
        this.scanningUpdatedTopic.publish((Serializable)new SecretScanningProcessingUpdated(SecretScanningProcessingUpdated.Type.QUEUED, String.valueOf(repository.getId()), commitIds.size()));
        this.bucketedExecutor.submit((Serializable)new AsyncSecretScanningRequest(repository, commitIds, initiatingUser));
    }

    @PostConstruct
    public void onStart() {
        if (this.jmxEnabled) {
            this.registerMxBean();
        }
        this.subscriptionId = this.scanningUpdatedTopic.subscribe(event -> {
            SecretScanningProcessingUpdated message = (SecretScanningProcessingUpdated)event.getMessage();
            if (message.getType() == SecretScanningProcessingUpdated.Type.QUEUED) {
                int taskCount = message.getTaskCount();
                this.queueSize.compute(message.getBucketId(), (bucketId, size) -> size == null ? taskCount : size + taskCount);
            } else if (message.getType() == SecretScanningProcessingUpdated.Type.COMPLETED) {
                this.queueSize.computeIfPresent(message.getBucketId(), (id, size) -> {
                    int tasks = size - message.getTaskCount();
                    return tasks == 0 ? null : Integer.valueOf(tasks);
                });
            }
        });
    }

    @PreDestroy
    public void onStop() {
        if (this.subscriptionId != null) {
            this.scanningUpdatedTopic.unsubscribe(this.subscriptionId);
            this.subscriptionId = null;
        }
        if (this.jmxEnabled) {
            this.unregisterMxBean();
        }
    }

    private static Function<AsyncSecretScanningRequest, String> toBucketId() {
        return request -> String.valueOf(request.getRepositoryId());
    }

    private void registerMxBean() {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(new SecretScanningProcessorMXBeanAdapter(), new ObjectName(MXBEAN_NAME));
        }
        catch (RuntimeException | JMException e) {
            log.warn("Could not register {}. Secret scanning bucket details will not be available in JMX.", (Object)SecretScanningProcessorMXBean.class.getName(), (Object)e);
        }
    }

    private void unregisterMxBean() {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(MXBEAN_NAME));
        }
        catch (RuntimeException | JMException e) {
            log.warn("Failed to unregister {}", (Object)SecretScanningProcessorMXBean.class.getName(), (Object)e);
        }
    }

    private class SecretScanningProcessorMXBeanAdapter
    implements SecretScanningProcessorMXBean {
        private SecretScanningProcessorMXBeanAdapter() {
        }

        @Override
        public long getActiveBucketCount() {
            return AsyncSecretScanningService.this.queueSize.entrySet().stream().filter(entry -> (Integer)entry.getValue() != 0).count();
        }

        @Override
        public Map<String, Integer> getQueueSizeForBuckets() {
            return AsyncSecretScanningService.this.queueSize;
        }
    }
}

