/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.secretscanning.async;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.internal.secretscanning.SecretScanningService;
import com.atlassian.bitbucket.internal.secretscanning.async.AsyncSecretScanningRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretScanningProcessor
implements BucketProcessor<AsyncSecretScanningRequest> {
    private static final Logger log = LoggerFactory.getLogger(SecretScanningProcessor.class);
    private final RepositoryService repositoryService;
    private final SecretScanningService secretScanningService;
    private final SecurityService securityService;

    public SecretScanningProcessor(RepositoryService repositoryService, SecretScanningService secretScanningService, SecurityService securityService) {
        this.repositoryService = repositoryService;
        this.secretScanningService = secretScanningService;
        this.securityService = securityService;
    }

    public void process(String bucketId, List<AsyncSecretScanningRequest> tasks) {
        Objects.requireNonNull(bucketId, "bucketId");
        Objects.requireNonNull(tasks, "tasks");
        Repository repository = (Repository)this.securityService.withPermission(Permission.REPO_READ, "Secret scanning").call(() -> this.repositoryService.getById(Integer.parseInt(bucketId)));
        if (repository == null) {
            log.debug("Repository with ID {} no longer exists. Skipping secret scanning.", (Object)bucketId);
            return;
        }
        tasks.forEach(t -> this.secretScanningService.onCommits(repository, t.getCommitIds(), t.getInitiatingUser()));
    }
}

